/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.red5.codec.IStreamCodecInfo;
import org.red5.codec.StreamCodecInfo;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeHandler;
import org.red5.server.api.stream.IStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.StreamState;
import org.red5.server.net.rtmp.event.Notify;

public abstract class AbstractStream
implements IStream {
    private String name;
    private IStreamCodecInfo codecInfo = new StreamCodecInfo();
    private transient AtomicReference<Notify> metaData = new AtomicReference();
    private IScope scope;
    private transient CopyOnWriteArrayList<PropertyChangeListener> stateListeners = new CopyOnWriteArrayList();
    protected long creationTime = System.currentTimeMillis();
    protected long startTime;
    protected final transient AtomicReference<StreamState> state = new AtomicReference<StreamState>(StreamState.UNINIT);

    protected void fireStateChange(StreamState oldState, StreamState newState) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "StreamState", (Object)oldState, (Object)newState);
        for (PropertyChangeListener listener : this.stateListeners) {
            listener.propertyChange(evt);
        }
    }

    public void addStateChangeListener(PropertyChangeListener listener) {
        if (!this.stateListeners.contains(listener)) {
            this.stateListeners.add(listener);
        }
    }

    public void removeStateChangeListener(PropertyChangeListener listener) {
        this.stateListeners.remove(listener);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IStreamCodecInfo getCodecInfo() {
        return this.codecInfo;
    }

    public Notify getMetaData() {
        Notify md = this.metaData.get();
        if (md != null) {
            try {
                return md.duplicate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return md;
    }

    public void setMetaData(Notify metaData) {
        this.metaData.set(metaData);
    }

    @Override
    public IScope getScope() {
        return this.scope;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCodecInfo(IStreamCodecInfo codecInfo) {
        this.codecInfo = codecInfo;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public StreamState getState() {
        return this.state.get();
    }

    public void setState(StreamState newState) {
        StreamState oldState = this.state.get();
        if (!oldState.equals((Object)newState) && this.state.compareAndSet(oldState, newState)) {
            this.fireStateChange(oldState, newState);
        }
    }

    protected IStreamAwareScopeHandler getStreamAwareHandler() {
        IScopeHandler handler;
        if (this.scope != null && (handler = this.scope.getHandler()) instanceof IStreamAwareScopeHandler) {
            return (IStreamAwareScopeHandler)handler;
        }
        return null;
    }
}

