/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.utils.HexDump;
import org.red5.server.api.event.IEvent;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.SerializeUtils;

public class Unknown
extends BaseEvent {
    private static final long serialVersionUID = -1352770037962252975L;
    protected IoBuffer data;
    protected byte dataType;

    public Unknown() {
    }

    public Unknown(byte dataType, IoBuffer data) {
        super(IEvent.Type.SYSTEM);
        this.dataType = dataType;
        this.data = data;
    }

    @Override
    public byte getDataType() {
        return this.dataType;
    }

    public IoBuffer getData() {
        return this.data;
    }

    public String toString() {
        IoBuffer buf = this.getData();
        StringBuffer sb = new StringBuffer();
        sb.append("Size: ");
        sb.append(buf.remaining());
        sb.append(" Data:\n\n");
        sb.append(HexDump.formatHexDump((String)buf.getHexDump()));
        return sb.toString();
    }

    @Override
    protected void releaseInternal() {
        if (this.data != null) {
            this.data.free();
            this.data = null;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.dataType = in.readByte();
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.data = IoBuffer.allocate((int)0);
            this.data.setAutoExpand(true);
            SerializeUtils.ByteArrayToByteBuffer(byteBuf, this.data);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(this.dataType);
        if (this.data != null) {
            out.writeObject(SerializeUtils.ByteBufferToByteArray(this.data));
        } else {
            out.writeObject(null);
        }
    }
}

