/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.IAudioStreamCodec;
import org.red5.codec.IStreamCodecInfo;
import org.red5.codec.IVideoStreamCodec;
import org.red5.codec.StreamCodecInfo;
import org.red5.io.amf.Output;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventDispatcher;
import org.red5.server.api.event.IEventListener;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeHandler;
import org.red5.server.api.statistics.IClientBroadcastStreamStatistics;
import org.red5.server.api.statistics.support.StatisticsCounter;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamListener;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.api.stream.StreamState;
import org.red5.server.jmx.mxbeans.ClientBroadcastStreamMXBean;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IFilter;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IMessageOutput;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.stream.AbstractClientStream;
import org.red5.server.stream.AudioCodecFactory;
import org.red5.server.stream.IConsumerService;
import org.red5.server.stream.IRecordingListener;
import org.red5.server.stream.IStreamData;
import org.red5.server.stream.RecordingListener;
import org.red5.server.stream.VideoCodecFactory;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.StatusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(objectName="org.red5.server:type=ClientBroadcastStream", description="ClientBroadcastStream")
public class ClientBroadcastStream
extends AbstractClientStream
implements IClientBroadcastStream,
IFilter,
IPushableConsumer,
IPipeConnectionListener,
IEventDispatcher,
IClientBroadcastStreamStatistics,
ClientBroadcastStreamMXBean {
    private static final Logger log = LoggerFactory.getLogger(ClientBroadcastStream.class);
    protected boolean automaticRecording;
    protected long bytesReceived;
    protected boolean checkVideoCodec = false;
    protected boolean checkAudioCodec = false;
    protected int chunkSize;
    protected volatile boolean closed;
    protected transient IMessageOutput connMsgOut;
    protected long firstPacketTime = -1L;
    protected transient IPipe livePipe;
    protected String publishedName;
    protected Map<String, String> parameters;
    protected boolean sendStartNotification = true;
    private transient StatisticsCounter subscriberStats = new StatisticsCounter();
    protected transient Set<IStreamListener> listeners = new CopyOnWriteArraySet<IStreamListener>();
    protected transient WeakReference<IRecordingListener> recordingListener;
    protected long latestTimeStamp = -1L;
    private boolean registerJMX = true;

    private void checkSendNotifications(IEvent event) {
        IEventListener source = event.getSource();
        this.sendStartNotifications(source);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.livePipe != null) {
            this.livePipe.unsubscribe(this);
        }
        if (this.recordingListener != null) {
            this.sendRecordStopNotify();
            this.notifyRecordingStop();
            ((IRecordingListener)this.recordingListener.get()).stop();
        }
        this.sendPublishStopNotify();
        if (this.connMsgOut != null) {
            this.connMsgOut.unsubscribe(this);
        }
        this.notifyBroadcastClose();
        if (this.recordingListener != null) {
            this.recordingListener.clear();
        }
        if (!this.listeners.isEmpty()) {
            this.listeners.clear();
        }
        this.unregisterJMX();
        this.setState(StreamState.CLOSED);
    }

    @Override
    public void dispatchEvent(IEvent event) {
        block40: {
            block39: {
                if (!(event instanceof IRTMPEvent) || this.closed) break block39;
                switch (event.getType()) {
                    case STREAM_CONTROL: 
                    case STREAM_DATA: {
                        IRTMPEvent rtmpEvent;
                        try {
                            rtmpEvent = (IRTMPEvent)event;
                        }
                        catch (ClassCastException e) {
                            log.error("Class cast exception in event dispatch", (Throwable)e);
                            return;
                        }
                        int eventTime = rtmpEvent.getTimestamp();
                        if (rtmpEvent.getSourceType() != 1) {
                            rtmpEvent.setSourceType((byte)1);
                        }
                        IoBuffer buf = null;
                        if (rtmpEvent instanceof IStreamData && (buf = ((IStreamData)((Object)rtmpEvent)).getData()) != null) {
                            this.bytesReceived += (long)buf.limit();
                        }
                        IStreamCodecInfo codecInfo = this.getCodecInfo();
                        StreamCodecInfo info = null;
                        if (codecInfo instanceof StreamCodecInfo) {
                            info = (StreamCodecInfo)codecInfo;
                        }
                        if (rtmpEvent instanceof AudioData) {
                            IAudioStreamCodec audioStreamCodec = null;
                            if (this.checkAudioCodec) {
                                if (buf.limit() > 0) {
                                    audioStreamCodec = AudioCodecFactory.getAudioCodec(buf);
                                    if (info != null) {
                                        info.setAudioCodec(audioStreamCodec);
                                    }
                                    this.checkAudioCodec = false;
                                }
                            } else if (codecInfo != null) {
                                audioStreamCodec = codecInfo.getAudioCodec();
                            }
                            if (audioStreamCodec != null) {
                                audioStreamCodec.addData(buf);
                            }
                            if (info != null) {
                                info.setHasAudio(true);
                            }
                        } else if (rtmpEvent instanceof VideoData) {
                            IVideoStreamCodec videoStreamCodec = null;
                            if (this.checkVideoCodec) {
                                videoStreamCodec = VideoCodecFactory.getVideoCodec(buf);
                                if (info != null) {
                                    info.setVideoCodec(videoStreamCodec);
                                }
                                this.checkVideoCodec = false;
                            } else if (codecInfo != null) {
                                videoStreamCodec = codecInfo.getVideoCodec();
                            }
                            if (videoStreamCodec != null) {
                                videoStreamCodec.addData(buf, eventTime);
                            }
                            if (info != null) {
                                info.setHasVideo(true);
                            }
                        } else {
                            Notify notifyEvent;
                            String action;
                            if (rtmpEvent instanceof Invoke) {
                                return;
                            }
                            if (rtmpEvent instanceof Notify && "onMetaData".equals(action = (notifyEvent = (Notify)rtmpEvent).getAction())) {
                                try {
                                    this.setMetaData(notifyEvent.duplicate());
                                }
                                catch (Exception e) {
                                    log.warn("Metadata could not be duplicated for this stream", (Throwable)e);
                                }
                            }
                        }
                        if ((long)eventTime > this.latestTimeStamp) {
                            this.latestTimeStamp = eventTime;
                        }
                        this.checkSendNotifications(event);
                        try {
                            if (this.livePipe != null) {
                                RTMPMessage msg = RTMPMessage.build(rtmpEvent, eventTime);
                                this.livePipe.pushMessage(msg);
                            } else if (log.isDebugEnabled()) {
                                log.debug("Live pipe was null, message was not pushed");
                            }
                        }
                        catch (IOException err) {
                            this.stop();
                        }
                        if (rtmpEvent instanceof IStreamPacket) {
                            for (IStreamListener listener : this.getStreamListeners()) {
                                try {
                                    listener.packetReceived(this, (IStreamPacket)((Object)rtmpEvent));
                                }
                                catch (Exception e) {
                                    log.error("Error while notifying listener {}", (Object)listener, (Object)e);
                                    if (!(listener instanceof RecordingListener)) continue;
                                    this.sendRecordFailedNotify(e.getMessage());
                                }
                            }
                        } else {
                            break;
                        }
                    }
                }
                break block40;
            }
            log.debug("Event was of wrong type or stream is closed ({})", (Object)this.closed);
        }
    }

    @Override
    public int getActiveSubscribers() {
        return this.subscriberStats.getCurrent();
    }

    @Override
    public long getBytesReceived() {
        return this.bytesReceived;
    }

    @Override
    public int getCurrentTimestamp() {
        return (int)this.latestTimeStamp;
    }

    @Override
    public int getMaxSubscribers() {
        return this.subscriberStats.getMax();
    }

    @Override
    public IProvider getProvider() {
        return this;
    }

    @Override
    public void setPublishedName(String name) {
        if (StringUtils.isNotEmpty((CharSequence)name) && !"false".equals(name)) {
            this.publishedName = name;
            this.registerJMX();
        }
    }

    @Override
    public String getPublishedName() {
        return this.publishedName;
    }

    @Override
    public void setParameters(Map<String, String> params) {
        this.parameters = params;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getSaveFilename() {
        if (this.recordingListener != null) {
            return ((IRecordingListener)this.recordingListener.get()).getFileName();
        }
        return null;
    }

    @Override
    public IClientBroadcastStreamStatistics getStatistics() {
        return this;
    }

    @Override
    public int getTotalSubscribers() {
        return this.subscriberStats.getTotal();
    }

    public boolean isAutomaticRecording() {
        return this.automaticRecording;
    }

    public void setAutomaticRecording(boolean automaticRecording) {
        this.automaticRecording = automaticRecording;
    }

    public void setRegisterJMX(boolean registerJMX) {
        this.registerJMX = registerJMX;
    }

    private void notifyBroadcastClose() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamBroadcastClose(this);
            }
            catch (Throwable t) {
                log.error("Error in notifyBroadcastClose", t);
            }
        }
    }

    private void notifyRecordingStop() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamRecordStop(this);
            }
            catch (Throwable t) {
                log.error("Error in notifyRecordingStop", t);
            }
        }
    }

    private void notifyBroadcastStart() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamBroadcastStart(this);
            }
            catch (Throwable t) {
                log.error("Error in notifyBroadcastStart", t);
            }
        }
        IoBuffer buf = IoBuffer.allocate((int)256);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<String, String> params = new HashMap<String, String>();
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeInMillis(this.creationTime);
        params.put("creationdate", ZonedDateTime.ofInstant(cal.toInstant(), ZoneId.of("UTC")).format(DateTimeFormatter.ISO_INSTANT));
        cal.setTimeInMillis(this.startTime);
        params.put("startdate", ZonedDateTime.ofInstant(cal.toInstant(), ZoneId.of("UTC")).format(DateTimeFormatter.ISO_INSTANT));
        if (log.isDebugEnabled()) {
            log.debug("Params: {}", params);
        }
        out.writeMap(params);
        buf.flip();
        Notify notify = new Notify(buf);
        notify.setAction("onMetaData");
        notify.setHeader(new Header());
        notify.getHeader().setDataType((byte)18);
        notify.getHeader().setStreamId(0);
        notify.setTimestamp(0);
        this.dispatchEvent(notify);
    }

    private void notifyChunkSize() {
        if (this.chunkSize > 0 && this.livePipe != null) {
            OOBControlMessage setChunkSize = new OOBControlMessage();
            setChunkSize.setTarget("ConnectionConsumer");
            setChunkSize.setServiceName("chunkSize");
            if (setChunkSize.getServiceParamMap() == null) {
                setChunkSize.setServiceParamMap(new HashMap<String, Object>());
            }
            setChunkSize.getServiceParamMap().put("chunkSize", this.chunkSize);
            this.livePipe.sendOOBControlMessage(this.getProvider(), setChunkSize);
        }
    }

    @Override
    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
        String target = oobCtrlMsg.getTarget();
        if ("ClientBroadcastStream".equals(target)) {
            String serviceName = oobCtrlMsg.getServiceName();
            if ("chunkSize".equals(serviceName)) {
                this.chunkSize = (Integer)oobCtrlMsg.getServiceParamMap().get("chunkSize");
                this.notifyChunkSize();
            } else {
                log.debug("Unhandled OOB control message for service: {}", (Object)serviceName);
            }
        } else {
            log.debug("Unhandled OOB control message to target: {}", (Object)target);
        }
    }

    @Override
    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case PROVIDER_CONNECT_PUSH: {
                if (event.getProvider() != this || event.getSource() == this.connMsgOut || event.getParamMap() != null && event.getParamMap().containsKey("record")) break;
                this.livePipe = (IPipe)event.getSource();
                for (IConsumer consumer : this.livePipe.getConsumers()) {
                    this.subscriberStats.increment();
                }
                break;
            }
            case PROVIDER_DISCONNECT: {
                if (this.livePipe != event.getSource()) break;
                this.livePipe = null;
                break;
            }
            case CONSUMER_CONNECT_PUSH: {
                IPipe pipe = (IPipe)event.getSource();
                if (this.livePipe == pipe) {
                    this.notifyChunkSize();
                }
                this.subscriberStats.increment();
                break;
            }
            case CONSUMER_DISCONNECT: {
                this.subscriberStats.decrement();
                break;
            }
        }
    }

    @Override
    public void pushMessage(IPipe pipe, IMessage message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAs(String name, boolean isAppend) throws IOException {
        IStreamCapableConnection conn = this.getConnection();
        if (conn == null) {
            throw new IOException("Stream is no longer connected");
        }
        if (this.recordingListener == null) {
            RecordingListener listener = new RecordingListener();
            if (listener.init(conn, name, isAppend)) {
                IStreamCodecInfo codecInfo = this.getCodecInfo();
                if (codecInfo instanceof StreamCodecInfo) {
                    StreamCodecInfo info = (StreamCodecInfo)codecInfo;
                    IVideoStreamCodec videoCodec = info.getVideoCodec();
                    if (videoCodec != null) {
                        IoBuffer config = videoCodec.getDecoderConfiguration();
                        if (config != null) {
                            VideoData videoConf = new VideoData(config.asReadOnlyBuffer());
                            try {
                                listener.getFileConsumer().setVideoDecoderConfiguration(videoConf);
                            }
                            finally {
                                videoConf.release();
                            }
                        }
                    } else {
                        log.debug("Could not initialize stream output, videoCodec is null.");
                    }
                    IAudioStreamCodec audioCodec = info.getAudioCodec();
                    if (audioCodec != null) {
                        IoBuffer config = audioCodec.getDecoderConfiguration();
                        if (config != null) {
                            AudioData audioConf = new AudioData(config.asReadOnlyBuffer());
                            try {
                                listener.getFileConsumer().setAudioDecoderConfiguration(audioConf);
                            }
                            finally {
                                audioConf.release();
                            }
                        }
                    } else {
                        log.debug("No decoder configuration available, audioCodec is null.");
                    }
                }
                this.recordingListener = new WeakReference<RecordingListener>(listener);
                this.addStreamListener(listener);
                listener.start();
            } else {
                log.warn("Recording listener failed to initialize for stream: {}", (Object)name);
            }
        } else {
            log.debug("Recording listener already exists for stream: {} auto record enabled: {}", (Object)name, (Object)this.automaticRecording);
        }
    }

    private void sendPublishStartNotify() {
        Status publishStatus = new Status("NetStream.Publish.Start");
        publishStatus.setClientid(this.getStreamId());
        publishStatus.setDetails(this.getPublishedName());
        StatusMessage startMsg = new StatusMessage();
        startMsg.setBody(publishStatus);
        this.pushMessage(startMsg);
        this.setState(StreamState.PUBLISHING);
    }

    private void sendPublishStopNotify() {
        Status stopStatus = new Status("NetStream.Unpublish.Success");
        stopStatus.setClientid(this.getStreamId());
        stopStatus.setDetails(this.getPublishedName());
        StatusMessage stopMsg = new StatusMessage();
        stopMsg.setBody(stopStatus);
        this.pushMessage(stopMsg);
        this.setState(StreamState.STOPPED);
    }

    private void sendRecordFailedNotify(String reason) {
        Status failedStatus = new Status("NetStream.Record.Failed");
        failedStatus.setLevel("error");
        failedStatus.setClientid(this.getStreamId());
        failedStatus.setDetails(this.getPublishedName());
        failedStatus.setDesciption(reason);
        StatusMessage failedMsg = new StatusMessage();
        failedMsg.setBody(failedStatus);
        this.pushMessage(failedMsg);
    }

    private void sendRecordStartNotify() {
        Status recordStatus = new Status("NetStream.Record.Start");
        recordStatus.setClientid(this.getStreamId());
        recordStatus.setDetails(this.getPublishedName());
        StatusMessage startMsg = new StatusMessage();
        startMsg.setBody(recordStatus);
        this.pushMessage(startMsg);
    }

    private void sendRecordStopNotify() {
        Status stopStatus = new Status("NetStream.Record.Stop");
        stopStatus.setClientid(this.getStreamId());
        stopStatus.setDetails(this.getPublishedName());
        StatusMessage stopMsg = new StatusMessage();
        stopMsg.setBody(stopStatus);
        this.pushMessage(stopMsg);
    }

    protected void pushMessage(StatusMessage msg) {
        if (this.connMsgOut != null) {
            try {
                this.connMsgOut.pushMessage(msg);
            }
            catch (IOException err) {
                log.error("Error while pushing message: {}", (Object)msg, (Object)err);
            }
        } else {
            log.warn("Consumer message output is null");
        }
    }

    private void sendStartNotifications(IEventListener source) {
        if (this.sendStartNotification) {
            IScopeHandler handler;
            IScope scope;
            this.sendStartNotification = false;
            if (source instanceof IConnection && (scope = ((IConnection)source).getScope()).hasHandler() && (handler = scope.getHandler()) instanceof IStreamAwareScopeHandler) {
                if (this.recordingListener != null && ((IRecordingListener)this.recordingListener.get()).isRecording()) {
                    ((IStreamAwareScopeHandler)handler).streamRecordStart(this);
                } else {
                    ((IStreamAwareScopeHandler)handler).streamPublishStart(this);
                }
            }
            this.sendPublishStartNotify();
            if (this.recordingListener != null && ((IRecordingListener)this.recordingListener.get()).isRecording()) {
                this.sendRecordStartNotify();
            }
            this.notifyBroadcastStart();
        }
    }

    @Override
    public void start() {
        this.checkVideoCodec = true;
        this.checkAudioCodec = true;
        this.firstPacketTime = -1L;
        this.latestTimeStamp = -1L;
        this.bytesReceived = 0L;
        IConsumerService consumerManager = (IConsumerService)this.getScope().getContext().getBean("consumerService");
        this.connMsgOut = consumerManager.getConsumerOutput(this);
        if (this.connMsgOut != null && this.connMsgOut.subscribe(this, null)) {
            this.startTime = System.currentTimeMillis();
            this.closed = false;
        } else {
            log.warn("Subscribe failed");
        }
        this.setState(StreamState.STARTED);
    }

    @Override
    public void startPublishing() {
        this.sendStartNotifications(Red5.getConnectionLocal());
        if (this.automaticRecording) {
            try {
                this.saveAs(this.publishedName, false);
            }
            catch (Exception e) {
                log.warn("Start of automatic recording failed", (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        this.setState(StreamState.STOPPED);
        this.stopRecording();
        this.close();
    }

    public void stopRecording() {
        IRecordingListener listener = null;
        if (this.recordingListener != null && (listener = (IRecordingListener)this.recordingListener.get()).isRecording()) {
            this.sendRecordStopNotify();
            this.notifyRecordingStop();
            this.removeStreamListener(listener);
            listener.stop();
            this.recordingListener.clear();
            this.recordingListener = null;
        }
    }

    public boolean isRecording() {
        return this.recordingListener != null && ((IRecordingListener)this.recordingListener.get()).isRecording();
    }

    @Override
    public void addStreamListener(IStreamListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Collection<IStreamListener> getStreamListeners() {
        return this.listeners;
    }

    @Override
    public void removeStreamListener(IStreamListener listener) {
        this.listeners.remove(listener);
    }

    protected File getRecordFile(IScope scope, String name) {
        return RecordingListener.getRecordFile(scope, name);
    }

    protected void registerJMX() {
        if (this.registerJMX) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName oName = new ObjectName(String.format("org.red5.server:type=ClientBroadcastStream,scope=%s,publishedName=%s", this.getScope().getName(), this.publishedName));
                mbs.registerMBean(new StandardMBean(this, ClientBroadcastStreamMXBean.class, true), oName);
            }
            catch (InstanceAlreadyExistsException e) {
                log.debug("Instance already registered", (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Error on jmx registration", (Throwable)e);
            }
        }
    }

    protected void unregisterJMX() {
        if (this.registerJMX && StringUtils.isNotEmpty((CharSequence)this.publishedName) && !"false".equals(this.publishedName)) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName oName = new ObjectName(String.format("org.red5.server:type=ClientBroadcastStream,scope=%s,publishedName=%s", this.getScope().getName(), this.publishedName));
                mbs.unregisterMBean(oName);
            }
            catch (Exception e) {
                log.warn("Exception unregistering", (Throwable)e);
            }
        }
    }
}

