/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmpt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Hex;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.net.IConnectionManager;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.InboundHandshake;
import org.red5.server.net.rtmp.RTMPConnManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.codec.RTMPProtocolEncoder;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.net.rtmpt.RTMPTConnection;
import org.red5.server.net.rtmpt.RTMPTHandler;
import org.red5.server.net.servlet.ServletUtils;
import org.red5.server.service.PendingCall;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RTMPTServlet
extends HttpServlet {
    private static final long serialVersionUID = 5925399677454936613L;
    protected static Logger log = Red5LoggerFactory.getLogger(RTMPTServlet.class);
    private static final String REQUEST_METHOD = "POST";
    private static final String CONTENT_TYPE = "application/x-fcs";
    private static IConnectionManager<RTMPConnection> manager;
    private static int targetResponseSize;
    private static RTMPTHandler handler;
    private static String ident2;
    private boolean enforceContentTypeCheck;
    protected ThreadLocal<RequestInfo> requestInfo = new ThreadLocal();
    protected transient WebApplicationContext applicationContext;

    protected void handleBadRequest(String message, HttpServletResponse resp) throws IOException {
        log.debug("handleBadRequest {}", (Object)message);
        Status status = new Status("NetConnection.Connect.Rejected", "error", message);
        PendingCall call = new PendingCall(null, "onStatus", new Object[]{status});
        Invoke event = new Invoke();
        event.setCall((IServiceCall)call);
        Header header = new Header();
        Packet packet = new Packet(header, (IRTMPEvent)event);
        header.setDataType(event.getDataType());
        RTMPConnection conn = (RTMPConnection)Red5.getConnectionLocal();
        if (conn == null) {
            try {
                conn = ((RTMPConnManager)manager).createConnectionInstance(RTMPTConnection.class);
                Red5.setConnectionLocal((IConnection)conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RTMPProtocolEncoder encoder = new RTMPProtocolEncoder();
        IoBuffer out = encoder.encodePacket(packet);
        this.returnMessage(null, out, resp);
        Red5.setConnectionLocal(null);
    }

    protected void returnMessage(byte message, HttpServletResponse resp) throws IOException {
        log.debug("returnMessage {}", (Object)message);
        resp.setStatus(200);
        resp.setHeader("Connection", "Keep-Alive");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setContentType(CONTENT_TYPE);
        resp.setContentLength(1);
        resp.getWriter().write(message);
        resp.flushBuffer();
    }

    protected void returnMessage(String message, HttpServletResponse resp) throws IOException {
        log.debug("returnMessage {}", (Object)message);
        resp.setStatus(200);
        resp.setHeader("Connection", "Keep-Alive");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setContentType(CONTENT_TYPE);
        resp.setContentLength(message.length());
        resp.getWriter().write(message);
        resp.flushBuffer();
    }

    protected void returnMessage(RTMPTConnection conn, IoBuffer buffer, HttpServletResponse resp) throws IOException {
        log.trace("returnMessage {}", (Object)buffer);
        if (conn != null) {
            resp.setStatus(200);
        } else {
            resp.setStatus(400);
        }
        resp.setHeader("Connection", "Keep-Alive");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setContentType(CONTENT_TYPE);
        int contentLength = buffer.limit() + 1;
        resp.setContentLength(contentLength);
        ServletOutputStream output = resp.getOutputStream();
        if (conn != null) {
            byte pollingDelay = conn.getPollingDelay();
            log.debug("Sending {} bytes; polling delay: {}", (Object)buffer.limit(), (Object)pollingDelay);
            output.write((int)pollingDelay);
        } else {
            output.write(0);
        }
        ServletUtils.copy((InputStream)buffer.asInputStream(), (OutputStream)output);
        if (conn != null) {
            conn.updateWrittenBytes(contentLength);
        }
        buffer.free();
        buffer = null;
    }

    protected void setRequestInfo(HttpServletRequest req) {
        Object[] arr = req.getRequestURI().trim().split("/");
        log.trace("Request parts: {}", (Object)Arrays.toString(arr));
        RequestInfo info = new RequestInfo((String)arr[2], Integer.valueOf((String)arr[3]));
        this.requestInfo.set(info);
    }

    protected void skipData(HttpServletRequest req) throws IOException {
        log.trace("skipData {}", (Object)req);
        int length = req.getContentLength();
        log.trace("Skipping {} bytes", (Object)length);
        IoBuffer data = IoBuffer.allocate((int)length);
        ServletUtils.copy((HttpServletRequest)req, (OutputStream)data.asOutputStream());
        data.flip();
        data.free();
        data = null;
        log.trace("Skipped {} bytes", (Object)length);
    }

    protected void returnPendingMessages(RTMPTConnection conn, HttpServletResponse resp) {
        log.debug("returnPendingMessages {}", (Object)conn);
        IoBuffer data = conn.getPendingMessages(targetResponseSize);
        if (data != null) {
            try {
                this.returnMessage(conn, data, resp);
            }
            catch (Exception ex) {
                log.warn("Exception returning outgoing data", (Throwable)ex);
                conn.close();
            }
        } else {
            log.debug("No messages to send");
            if (conn.isClosing()) {
                log.debug("Client is closing, send close notification");
                try {
                    this.returnMessage((byte)0, resp);
                }
                catch (IOException ex) {
                    log.warn("Exception returning outgoing data - close notification", (Throwable)ex);
                }
            } else {
                try {
                    this.returnMessage(conn.getPollingDelay(), resp);
                }
                catch (IOException ex) {
                    log.warn("Exception returning outgoing data - polling delay", (Throwable)ex);
                }
            }
        }
    }

    protected void handleOpen(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.debug("handleOpen");
        this.skipData(req);
        RTMPTConnection conn = (RTMPTConnection)((Object)manager.createConnection(RTMPTConnection.class));
        log.trace("{}", (Object)conn);
        if (conn != null) {
            conn.setServlet(this);
            conn.setServletRequest(req);
            manager.setConnection((Object)conn);
            conn.setHandler((IRTMPHandler)handler);
            conn.setDecoder(handler.getCodecFactory().getRTMPDecoder());
            conn.setEncoder(handler.getCodecFactory().getRTMPEncoder());
            handler.connectionOpened(conn);
            conn.dataReceived();
            conn.updateReadBytes(req.getContentLength());
            Red5.setConnectionLocal((IConnection)conn);
            if (conn.getId() != 0) {
                this.returnMessage(String.format("%s\n", conn.getSessionId()), resp);
            } else {
                this.returnMessage((byte)0, resp);
            }
        } else {
            resp.setStatus(500);
            resp.setHeader("Connection", "Keep-Alive");
            resp.setHeader("Cache-Control", "no-cache");
            resp.flushBuffer();
        }
    }

    protected void handleClose(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.debug("handleClose");
        this.skipData(req);
        RTMPTConnection connection = this.getConnection();
        if (connection != null) {
            log.debug("Pending messges on close: {}", (Object)connection.getPendingMessages());
            this.returnMessage((byte)0, resp);
            connection.close();
        } else {
            this.handleBadRequest(String.format("Close: unknown client session: %s", this.requestInfo.get().getSessionId()), resp);
        }
    }

    protected void handleSend(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.debug("handleSend");
        RTMPTConnection conn = this.getConnection();
        if (conn != null) {
            IoSession session = conn.getIoSession();
            InboundHandshake handshake = null;
            int length = req.getContentLength();
            log.trace("Request content length: {}", (Object)length);
            IoBuffer message = IoBuffer.allocate((int)length);
            ServletUtils.copy((HttpServletRequest)req, (OutputStream)message.asOutputStream());
            message.flip();
            RTMP rtmp = conn.getState();
            byte connectionState = rtmp.getState();
            switch (connectionState) {
                case 0: {
                    log.debug("decodeHandshakeC0C1 - buffer: {}", (Object)message);
                    if (message.remaining() < 1537) break;
                    byte connectionType = message.get();
                    log.trace("Incoming C0 connection type: {}", (Object)connectionType);
                    handshake = new InboundHandshake(connectionType);
                    handshake.setUnvalidatedConnectionAllowed(handler.isUnvalidatedConnectionAllowed());
                    session.setAttribute((Object)"rtmp.handshake", (Object)handshake);
                    byte[] dst = new byte[1536];
                    message.get(dst);
                    rtmp.setState((byte)1);
                    IoBuffer s1 = handshake.decodeClientRequest1(IoBuffer.wrap((byte[])dst));
                    if (s1 != null) {
                        conn.writeRaw(s1);
                        break;
                    }
                    log.warn("Client was rejected due to invalid handshake");
                    conn.close();
                    break;
                }
                case 1: {
                    log.debug("decodeHandshakeC2 - buffer: {}", (Object)message);
                    if (message.remaining() >= 1536) {
                        handshake = (InboundHandshake)((Object)session.getAttribute((Object)"rtmp.handshake"));
                        byte[] dst = new byte[1536];
                        message.get(dst);
                        log.trace("Copied {}", (Object)Hex.encodeHexString((byte[])dst));
                        if (handshake.decodeClientRequest2(IoBuffer.wrap((byte[])dst))) {
                            log.debug("Connected, removing handshake data and adding rtmp protocol filter");
                            rtmp.setState((byte)2);
                            session.removeAttribute((Object)"rtmp.handshake");
                        } else {
                            log.warn("Client was rejected due to invalid handshake");
                            conn.close();
                        }
                    }
                }
                case 2: {
                    for (Object obj : conn.decode(message)) {
                        conn.handleMessageReceived(obj);
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    log.debug("Nothing to do, connection state: {}", (Object)RTMP.states[connectionState]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid RTMP state: " + connectionState);
                }
            }
            conn.dataReceived();
            conn.updateReadBytes(length);
            message.clear();
            message.free();
            this.returnPendingMessages(conn, resp);
        } else {
            this.handleBadRequest(String.format("Send: unknown client session: %s", this.requestInfo.get().getSessionId()), resp);
        }
    }

    protected void handleIdle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        log.debug("handleIdle");
        this.skipData(req);
        RTMPTConnection conn = this.getConnection();
        if (conn != null) {
            conn.dataReceived();
            conn.updateReadBytes(req.getContentLength());
            this.returnPendingMessages(conn, resp);
        } else {
            this.handleBadRequest(String.format("Idle: unknown client session: %s", this.requestInfo.get().getSessionId()), resp);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.applicationContext == null) {
            ServletContext ctx = this.getServletContext();
            this.applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)ctx);
            if (this.applicationContext == null) {
                this.applicationContext = (WebApplicationContext)ctx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            }
            log.debug("Application context: {}", (Object)this.applicationContext);
            if (manager == null) {
                log.warn("Class instance connection manager was null, looking up in application context");
                manager = (RTMPConnManager)this.applicationContext.getBean("rtmpConnManager");
                if (manager == null) {
                    log.warn("Connection manager was null in context, getting class instance");
                    manager = RTMPConnManager.getInstance();
                    if (manager == null) {
                        log.error("Connection manager is still null, this is bad");
                    }
                }
            }
        }
        log.debug("Request - method: {} content type: {} path: {}", new Object[]{req.getMethod(), req.getContentType(), req.getServletPath()});
        if (!REQUEST_METHOD.equals(req.getMethod()) || req.getContentLength() == 0) {
            this.handleBadRequest("Bad request, only RTMPT supported.", resp);
            return;
        }
        if (this.enforceContentTypeCheck && !CONTENT_TYPE.equals(req.getContentType())) {
            this.handleBadRequest(String.format("Bad request, unsupported content type: %s.", req.getContentType()), resp);
            return;
        }
        String uri = req.getRequestURI().trim();
        log.debug("URI: {}", (Object)uri);
        String path = req.getServletPath();
        char p = path.charAt(1);
        switch (p) {
            case 'o': {
                this.handleOpen(req, resp);
                break;
            }
            case 'c': {
                this.setRequestInfo(req);
                this.handleClose(req, resp);
                this.requestInfo.remove();
                break;
            }
            case 's': {
                this.setRequestInfo(req);
                this.handleSend(req, resp);
                this.requestInfo.remove();
                break;
            }
            case 'i': {
                this.setRequestInfo(req);
                this.handleIdle(req, resp);
                this.requestInfo.remove();
                break;
            }
            case 'f': {
                String ident = "<fcs><Company>Red5</Company><Team>Red5 Server</Team></fcs>";
                if (uri.charAt(uri.length() - 1) == '2') {
                    if (ident2 != null) {
                        ident = ident2;
                    } else {
                        resp.setStatus(404);
                        resp.setHeader("Connection", "Keep-Alive");
                        resp.setHeader("Cache-Control", "no-cache");
                        resp.flushBuffer();
                        break;
                    }
                }
                resp.setStatus(200);
                resp.setHeader("Connection", "Keep-Alive");
                resp.setHeader("Cache-Control", "no-cache");
                resp.setContentType(CONTENT_TYPE);
                resp.setContentLength(ident.length());
                resp.getWriter().write(ident);
                resp.flushBuffer();
                break;
            }
            default: {
                this.handleBadRequest(String.format("RTMPT command %s is not supported.", path), resp);
            }
        }
        Red5.setConnectionLocal(null);
    }

    public void destroy() {
        Collection conns = manager.getAllConnections();
        for (RTMPConnection conn : conns) {
            if (!(conn instanceof RTMPTConnection)) continue;
            log.debug("Connection scope on destroy: {}", (Object)conn.getScope());
            conn.close();
        }
        super.destroy();
    }

    protected RTMPTConnection getConnection() {
        String sessionId = this.requestInfo.get().getSessionId();
        RTMPTConnection conn = (RTMPTConnection)((Object)manager.getConnectionBySessionId(sessionId));
        if (conn != null) {
            if (!conn.isDisconnected()) {
                Red5.setConnectionLocal((IConnection)conn);
            } else {
                this.removeConnection(sessionId);
            }
        } else {
            log.warn("Null connection for session id: {}", (Object)sessionId);
        }
        return conn;
    }

    protected void removeConnection(String sessionId) {
        log.debug("Removing connection for session id: {}", (Object)sessionId);
        RTMPTConnection conn = (RTMPTConnection)((Object)manager.getConnectionBySessionId(sessionId));
        if (conn != null) {
            manager.removeConnection(conn.getSessionId());
        } else {
            log.warn("Remove failed, null connection for session id: {}", (Object)sessionId);
        }
    }

    public void setManager(IConnectionManager<RTMPConnection> manager) {
        log.trace("Set connection manager: {}", manager);
        RTMPTServlet.manager = manager;
    }

    public void setHandler(RTMPTHandler handler) {
        log.trace("Set handler: {}", (Object)handler);
        RTMPTServlet.handler = handler;
    }

    public void setIdent2(String ident2) {
        RTMPTServlet.ident2 = ident2;
    }

    public void setTargetResponseSize(int targetResponseSize) {
        RTMPTServlet.targetResponseSize = targetResponseSize;
    }

    public boolean isEnforceContentTypeCheck() {
        return this.enforceContentTypeCheck;
    }

    public void setEnforceContentTypeCheck(boolean enforceContentTypeCheck) {
        this.enforceContentTypeCheck = enforceContentTypeCheck;
    }

    static {
        targetResponseSize = 32768;
    }

    protected final class RequestInfo {
        private String sessionId;
        private Integer requestNumber;

        RequestInfo(String sessionId, Integer requestNumber) {
            this.sessionId = sessionId;
            this.requestNumber = requestNumber;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Integer getRequestNumber() {
            return this.requestNumber;
        }
    }
}

