/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.apache.commons.codec.binary.Hex;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.InboundHandshake;
import org.red5.server.net.rtmp.RTMPConnManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPHandler;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmpe.RTMPEIoFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPMinaIoHandler
extends IoHandlerAdapter {
    private static Logger log = LoggerFactory.getLogger(RTMPMinaIoHandler.class);
    protected IRTMPHandler handler;

    public void sessionCreated(IoSession session) throws Exception {
        log.debug("Session created RTMP");
        session.getFilterChain().addFirst("rtmpeFilter", (IoFilter)new RTMPEIoFilter());
        RTMPMinaConnection conn = this.createRTMPMinaConnection();
        conn.setIoSession(session);
        conn.setHandler(this.handler);
        session.setAttribute((Object)"rtmp.sessionid", (Object)conn.getSessionId());
        InboundHandshake handshake = new InboundHandshake();
        handshake.setUnvalidatedConnectionAllowed(((RTMPHandler)this.handler).isUnvalidatedConnectionAllowed());
        session.setAttribute((Object)"rtmp.handshake", (Object)handshake);
    }

    public void sessionOpened(IoSession session) throws Exception {
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        log.debug("Session opened: {} id: {}", (Object)session.getId(), (Object)sessionId);
        RTMPConnManager connManager = (RTMPConnManager)RTMPConnManager.getInstance();
        session.setAttribute((Object)"rtmp.connection.manager", new WeakReference<RTMPConnManager>(connManager));
        RTMPMinaConnection conn = (RTMPMinaConnection)connManager.getConnectionBySessionId(sessionId);
        this.handler.connectionOpened((RTMPConnection)conn);
    }

    public void sessionClosed(IoSession session) throws Exception {
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        log.debug("Session closed: {} id: {}", (Object)session.getId(), (Object)sessionId);
        if (log.isTraceEnabled()) {
            log.trace("Session attributes: {}", (Object)session.getAttributeKeys());
        }
        if (sessionId != null) {
            RTMPMinaConnection conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
            if (conn != null) {
                this.handler.connectionClosed((RTMPConnection)conn);
                if (session.containsAttribute((Object)"rtmp.handshake")) {
                    session.removeAttribute((Object)"rtmp.handshake");
                }
                if (session.containsAttribute((Object)"rtmpe.cipher.in")) {
                    session.removeAttribute((Object)"rtmpe.cipher.in");
                    session.removeAttribute((Object)"rtmpe.cipher.out");
                }
            } else {
                log.warn("Connection was not found for {}", (Object)sessionId);
            }
            this.cleanSession(session, false);
        } else {
            log.debug("Connections session id was null in session, may already be closed");
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        RTMPMinaConnection conn;
        if (log.isTraceEnabled()) {
            log.trace("messageReceived session: {} message: {}", (Object)session, message);
            log.trace("Filter chain: {}", (Object)session.getFilterChain());
        }
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        if (log.isTraceEnabled()) {
            log.trace("Message received on session: {} id: {}", (Object)session.getId(), (Object)sessionId);
        }
        if ((conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId)) != null) {
            if (message != null && message instanceof Packet) {
                byte state = conn.getStateCode();
                if (state != 4 && state != 5) {
                    Red5.setConnectionLocal((IConnection)conn);
                    conn.handleMessageReceived((Packet)message);
                    Red5.setConnectionLocal(null);
                } else {
                    log.info("Ignoring received message on {} due to state: {}", (Object)sessionId, (Object)RTMP.states[state]);
                }
            }
        } else {
            log.warn("Connection was not found for {}, force closing", (Object)sessionId);
            this.forceClose(session);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        log.trace("messageSent session: {} message: {}", (Object)session, message);
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        if (log.isTraceEnabled()) {
            log.trace("Message sent on session: {} id: {}", (Object)session.getId(), (Object)sessionId);
        }
        if (sessionId != null) {
            RTMPMinaConnection conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
            if (conn != null) {
                byte state = conn.getStateCode();
                switch (state) {
                    case 2: {
                        if (message instanceof Packet) {
                            this.handler.messageSent((RTMPConnection)conn, (Packet)message);
                            break;
                        }
                        if (!log.isDebugEnabled()) break;
                        log.debug("Message was not of Packet type; its type: {}", (Object)(message != null ? message.getClass().getName() : "null"));
                        break;
                    }
                    case 0: 
                    case 1: {
                        if (!log.isTraceEnabled()) break;
                        log.trace("messageSent: {}", (Object)Hex.encodeHexString((byte[])((IoBuffer)message).array()));
                        break;
                    }
                }
            } else {
                log.warn("Destination connection was null, it is already disposed. Session id: {}", (Object)sessionId);
            }
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        log.debug("Filter chain: {}", (Object)session.getFilterChain());
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        if (log.isDebugEnabled()) {
            log.warn("Exception caught on session: {} id: {}", new Object[]{session.getId(), sessionId, cause});
        }
        if (cause instanceof IOException) {
            log.debug("IOException caught on {}", (Object)sessionId);
        } else {
            log.debug("Non-IOException caught on {}", (Object)sessionId);
            this.forceClose(session);
        }
    }

    private void forceClose(IoSession session) {
        log.warn("Force close - session: {}", (Object)session.getId());
        if (session.containsAttribute((Object)"FORCED_CLOSE")) {
            log.info("Close already forced on this session: {}", (Object)session.getId());
        } else {
            session.setAttribute((Object)"FORCED_CLOSE", (Object)Boolean.TRUE);
            session.suspendRead();
            this.cleanSession(session, true);
        }
    }

    private void cleanSession(final IoSession session, boolean immediately) {
        WriteRequestQueue writeQueue;
        final String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        if (log.isDebugEnabled()) {
            log.debug("Forcing close on session: {} id: {}", (Object)session.getId(), (Object)sessionId);
            log.debug("Session closing: {}", (Object)session.isClosing());
        }
        if ((writeQueue = session.getWriteRequestQueue()) != null && !writeQueue.isEmpty(session)) {
            log.debug("Clearing write queue");
            try {
                writeQueue.clear(session);
            }
            catch (Exception ex) {
                log.warn("Exception clearing write queue for {}", (Object)sessionId, (Object)ex);
            }
        }
        CloseFuture future = immediately ? session.close(false) : session.close(true);
        IoFutureListener<CloseFuture> listener = new IoFutureListener<CloseFuture>(){

            public void operationComplete(CloseFuture future) {
                log.debug("Close operation completed {}: {}", (Object)sessionId, (Object)future.isClosed());
                future.removeListener((IoFutureListener)this);
                for (Object key : session.getAttributeKeys()) {
                    Object obj = session.getAttribute(key);
                    log.debug("{}: {}", key, obj);
                    if (obj == null) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("Attribute: {}", (Object)obj.getClass().getName());
                    }
                    if (obj instanceof IoProcessor) {
                        log.debug("Flushing session in processor");
                        ((IoProcessor)obj).flush(session);
                        log.debug("Removing session from processor");
                        ((IoProcessor)obj).remove(session);
                        continue;
                    }
                    if (!(obj instanceof IoBuffer)) continue;
                    log.debug("Clearing session buffer");
                    ((IoBuffer)obj).clear();
                    ((IoBuffer)obj).free();
                }
            }
        };
        future.addListener((IoFutureListener)listener);
    }

    public void setHandler(IRTMPHandler handler) {
        this.handler = handler;
    }

    @Deprecated
    public void setCodecFactory(ProtocolCodecFactory codecFactory) {
        log.warn("This option is deprecated, the codec factory is now contained within the RTMPEIoFilter");
    }

    protected RTMPMinaConnection createRTMPMinaConnection() {
        return (RTMPMinaConnection)RTMPConnManager.getInstance().createConnection(RTMPMinaConnection.class);
    }
}

