/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scheduling;

import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.servlet.ServletContext;
import org.quartz.impl.StdSchedulerFactory;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.jmx.mxbeans.QuartzSchedulingServiceMXBean;
import org.red5.server.scheduling.QuartzSchedulingService;
import org.slf4j.Logger;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(objectName="org.red5.server:type=ApplicationSchedulingService,name=default")
public class ApplicationSchedulingService
extends QuartzSchedulingService {
    private static Logger log = Red5LoggerFactory.getLogger(ApplicationSchedulingService.class);
    public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
    private String applicationName;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setServletAttribute(ServletContext servletContext) {
        log.debug("Storing the scheduler factory in the servlet context");
        servletContext.setAttribute(QUARTZ_FACTORY_KEY, (Object)this.factory);
    }

    public String getJobName() {
        return String.format("%s_ScheduledJob_%d", this.applicationName, this.jobDetailCounter.getAndIncrement());
    }

    public void afterPropertiesSet() throws Exception {
        log.info("Application scheduler initializing...");
        try {
            if (this.configFile != null) {
                this.factory = new StdSchedulerFactory(this.configFile);
            } else {
                Properties props = new Properties();
                props.put("org.quartz.scheduler.instanceName", this.applicationName + "_Scheduler");
                props.put("org.quartz.scheduler.instanceId", "AUTO");
                props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
                props.put("org.quartz.threadPool.threadCount", "2");
                props.put("org.quartz.threadPool.threadPriority", "5");
                props.put("org.quartz.jobStore.misfireThreshold", "60000");
                props.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
                this.factory = new StdSchedulerFactory(props);
            }
            super.afterPropertiesSet();
        }
        catch (Exception e) {
            log.error("Quartz Scheduler failed to initialize", (Throwable)e);
        }
    }

    protected void registerJMX() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName oName = null;
            oName = this.instanceId == null ? new ObjectName("org.red5.server:type=ApplicationSchedulingService,applicationName=" + this.applicationName) : new ObjectName("org.red5.server:type=ApplicationSchedulingService,applicationName=" + this.applicationName + ",instanceId=" + this.instanceId);
            mbeanServer.registerMBean(new StandardMBean(this, QuartzSchedulingServiceMXBean.class, true), oName);
        }
        catch (Exception e) {
            log.warn("Error on jmx registration", (Throwable)e);
        }
    }

    protected void unregisterJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName oName = null;
            oName = this.instanceId == null ? new ObjectName("org.red5.server:type=ApplicationSchedulingService,applicationName=" + this.applicationName) : new ObjectName("org.red5.server:type=ApplicationSchedulingService,applicationName=" + this.applicationName + ",instanceId=" + this.instanceId);
            mbs.unregisterMBean(oName);
        }
        catch (Exception e) {
            log.warn("Exception unregistering", (Throwable)e);
        }
    }
}

