/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.war;

import ch.qos.logback.classic.LoggerContext;
import java.beans.Introspector;
import java.io.File;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.red5.io.amf.Output;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.ClientRegistry;
import org.red5.server.Context;
import org.red5.server.MappingStrategy;
import org.red5.server.Server;
import org.red5.server.api.IClientRegistry;
import org.red5.server.api.IServer;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.scope.GlobalScope;
import org.red5.server.scope.ScopeResolver;
import org.red5.server.scope.WebScope;
import org.red5.server.service.ServiceInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class WarLoaderServlet
extends ContextLoaderListener {
    public static final Logger logger = Red5LoggerFactory.getLogger(WarLoaderServlet.class);
    private static ArrayList<ServletContext> registeredContexts = new ArrayList(3);
    private ConfigurableWebApplicationContext applicationContext;
    private DefaultListableBeanFactory parentFactory;
    private static ServletContext servletContext;
    private ClientRegistry clientRegistry;
    private ServiceInvoker globalInvoker;
    private MappingStrategy globalStrategy;
    private ScopeResolver globalResolver;
    private GlobalScope global;
    private Server server;

    public void contextInitialized(ServletContextEvent sce) {
        if (null != servletContext) {
            return;
        }
        System.setProperty("red5.deployment.type", "war");
        servletContext = sce.getServletContext();
        String prefix = servletContext.getRealPath("/");
        if (System.getProperty("red5.webapp.root") == null) {
            File webapps = new File(prefix);
            System.setProperty("red5.webapp.root", webapps.getParent());
            webapps = null;
        }
        long time = System.currentTimeMillis();
        logger.info("{} WAR loader", (Object)"Red5 Server 1.0.10");
        logger.debug("Path: {}", (Object)prefix);
        try {
            super.contextInitialized(sce);
            this.applicationContext = (ConfigurableWebApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            logger.debug("Root context path: {}", (Object)this.applicationContext.getServletContext().getContextPath());
            ConfigurableListableBeanFactory factory = this.applicationContext.getBeanFactory();
            factory.registerSingleton("default.context", (Object)this.applicationContext);
            this.parentFactory = (DefaultListableBeanFactory)factory.getParentBeanFactory();
        }
        catch (Throwable t) {
            logger.error("", t);
        }
        long startupIn = System.currentTimeMillis() - time;
        logger.info("Startup done in: {} ms", (Object)startupIn);
    }

    public void registerSubContext(String webAppKey) {
        ServletContext ctx = servletContext.getContext(webAppKey);
        if (ctx == null) {
            ctx = servletContext;
        }
        ContextLoader loader = new ContextLoader();
        ConfigurableWebApplicationContext appCtx = (ConfigurableWebApplicationContext)loader.initWebApplicationContext(ctx);
        appCtx.setParent((ApplicationContext)this.applicationContext);
        appCtx.refresh();
        ctx.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)appCtx);
        ConfigurableListableBeanFactory appFactory = appCtx.getBeanFactory();
        logger.debug("About to grab Webcontext bean for {}", (Object)webAppKey);
        Context webContext = (Context)appCtx.getBean("web.context");
        webContext.setCoreBeanFactory((BeanFactory)this.parentFactory);
        webContext.setClientRegistry((IClientRegistry)this.clientRegistry);
        webContext.setServiceInvoker((IServiceInvoker)this.globalInvoker);
        webContext.setScopeResolver(this.globalResolver);
        webContext.setMappingStrategy(this.globalStrategy);
        WebScope scope = (WebScope)appFactory.getBean("web.scope");
        scope.setServer((IServer)this.server);
        scope.setParent((IScope)this.global);
        scope.register();
        scope.start();
        registeredContexts.add(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext servletContext = WarLoaderServlet.servletContext;
        synchronized (servletContext) {
            block15: {
                logger.info("Webapp shutdown");
                ServletContext ctx = null;
                try {
                    ctx = sce.getServletContext();
                    Introspector.flushCaches();
                    Enumeration<Driver> e22 = DriverManager.getDrivers();
                    while (e22.hasMoreElements()) {
                        Driver driver = e22.nextElement();
                        if (driver.getClass().getClassLoader() != ((Object)((Object)this)).getClass().getClassLoader()) continue;
                        DriverManager.deregisterDriver(driver);
                    }
                    Output.destroyCache();
                    try {
                        ((LoggerContext)LoggerFactory.getILoggerFactory()).stop();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                    Object attr = ctx.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                    if (attr == null) break block15;
                    ConfigurableWebApplicationContext applicationContext = (ConfigurableWebApplicationContext)attr;
                    ConfigurableListableBeanFactory factory = applicationContext.getBeanFactory();
                    try {
                        for (String singleton : factory.getSingletonNames()) {
                            logger.debug("Registered singleton: {}", (Object)singleton);
                            factory.destroyScopedBean(singleton);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    factory.destroySingletons();
                    applicationContext.close();
                }
                catch (Throwable e) {
                    logger.warn("Exception {}", e);
                }
                finally {
                    super.contextDestroyed(sce);
                    if (ctx != null) {
                        ctx.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                    }
                }
            }
        }
    }
}

