/*
 * Decompiled with CFR 0.152.
 */
package org.red5.codec;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AbstractVideo;
import org.red5.codec.IVideoStreamCodec;
import org.red5.codec.VideoCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AVCVideo
extends AbstractVideo {
    private static Logger log = LoggerFactory.getLogger(AVCVideo.class);
    static final String CODEC_NAME = "AVC";
    private IVideoStreamCodec.FrameData decoderConfiguration;
    private final CopyOnWriteArrayList<IVideoStreamCodec.FrameData> interframes = new CopyOnWriteArrayList();
    private final AtomicInteger numInterframes = new AtomicInteger(0);
    private boolean bufferInterframes = true;

    public AVCVideo() {
        this.reset();
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public boolean canDropFrames() {
        return true;
    }

    @Override
    public void reset() {
        this.decoderConfiguration = new IVideoStreamCodec.FrameData();
        this.softReset();
    }

    private void softReset() {
        this.keyframes.clear();
        this.interframes.clear();
        this.numInterframes.set(0);
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        boolean result = false;
        if (data.limit() > 0) {
            result = (data.get() & 0xF) == VideoCodec.AVC.getId();
            data.rewind();
        }
        return result;
    }

    @Override
    public boolean addData(IoBuffer data) {
        return this.addData(data, this.keyframeTimestamp + 1);
    }

    @Override
    public boolean addData(IoBuffer data, int timestamp) {
        if (data.hasRemaining()) {
            int start;
            block12: {
                start = data.position();
                byte frameType = data.get();
                if ((frameType & 0xF) == VideoCodec.AVC.getId()) {
                    if ((frameType & 0xF0) == 16) {
                        byte AVCPacketType = data.get();
                        data.rewind();
                        if (AVCPacketType == 0) {
                            this.decoderConfiguration.setData(data);
                            this.softReset();
                        } else {
                            if (timestamp != this.keyframeTimestamp) {
                                this.keyframeTimestamp = timestamp;
                                this.softReset();
                            }
                            this.keyframes.add(new IVideoStreamCodec.FrameData(data));
                        }
                    } else if (this.bufferInterframes) {
                        data.rewind();
                        try {
                            int lastInterframe = this.numInterframes.getAndIncrement();
                            if (lastInterframe < this.interframes.size()) {
                                this.interframes.get(lastInterframe).setData(data);
                                break block12;
                            }
                            this.interframes.add(new IVideoStreamCodec.FrameData(data));
                        }
                        catch (Throwable e) {
                            log.error("Failed to buffer interframe", e);
                        }
                    }
                } else {
                    log.debug("Non-AVC data, rejecting");
                    data.position(start);
                    return false;
                }
            }
            data.position(start);
        }
        return true;
    }

    @Override
    public IoBuffer getDecoderConfiguration() {
        return this.decoderConfiguration.getFrame();
    }

    @Override
    public int getNumInterframes() {
        return this.numInterframes.get();
    }

    @Override
    public IVideoStreamCodec.FrameData getInterframe(int index) {
        if (index < this.numInterframes.get()) {
            return this.interframes.get(index);
        }
        return null;
    }

    public boolean isBufferInterframes() {
        return this.bufferInterframes;
    }

    public void setBufferInterframes(boolean bufferInterframes) {
        this.bufferInterframes = bufferInterframes;
    }
}

