/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.lang.reflect.Array;
import java.util.Collection;

public final class ArrayUtils {
    public static Object getArray(Class<?> type, int count) {
        if (Byte.TYPE.isAssignableFrom(type)) {
            return new byte[count];
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return new short[count];
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return new int[count];
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return new long[count];
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return new float[count];
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return new double[count];
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return new boolean[count];
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return new char[count];
        }
        if (null != type) {
            return Array.newInstance(type, count);
        }
        return new Object[count];
    }

    public static Object fillArray(Class<?> type, Collection collection) {
        if (Byte.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toByteArray(collection);
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toShortArray(collection);
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toIntegerArray(collection);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toLongArray(collection);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toFloatArray(collection);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toDoubleArray(collection);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toBooleanArray(collection);
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toCharacterArray(collection);
        }
        return ArrayUtils.toObjectArray(type, collection);
    }

    public static Object fillArray(Class<?> type, Object array, Collection collection) {
        if (Byte.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toByteArray(array, collection);
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toShortArray(array, collection);
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toIntegerArray(array, collection);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toLongArray(array, collection);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toFloatArray(array, collection);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toDoubleArray(array, collection);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toBooleanArray(array, collection);
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return ArrayUtils.toCharacterArray(array, collection);
        }
        return ArrayUtils.toObjectArray(array, collection);
    }

    private static Object toByteArray(Collection collection) {
        return ArrayUtils.toByteArray(new byte[collection.size()], collection);
    }

    private static Object toByteArray(Object array, Collection collection) {
        byte[] ba = (byte[])array;
        int i = 0;
        for (Object o : collection) {
            byte b = (Byte)o;
            ba[i++] = b;
        }
        return ba;
    }

    private static Object toShortArray(Collection collection) {
        return ArrayUtils.toShortArray(new short[collection.size()], collection);
    }

    private static Object toShortArray(Object array, Collection collection) {
        short[] sa = (short[])array;
        int i = 0;
        for (Object o : collection) {
            short s = (Short)o;
            sa[i++] = s;
        }
        return sa;
    }

    private static Object toIntegerArray(Collection collection) {
        return ArrayUtils.toIntegerArray(new int[collection.size()], collection);
    }

    private static Object toIntegerArray(Object array, Collection collection) {
        int[] ia = (int[])array;
        int i = 0;
        for (Object o : collection) {
            int j = (Integer)o;
            ia[i++] = j;
        }
        return ia;
    }

    private static Object toLongArray(Collection collection) {
        return ArrayUtils.toLongArray(new long[collection.size()], collection);
    }

    private static Object toLongArray(Object array, Collection collection) {
        long[] la = (long[])array;
        int i = 0;
        for (Object o : collection) {
            long l = (Long)o;
            la[i++] = l;
        }
        return la;
    }

    private static Object toFloatArray(Collection collection) {
        return ArrayUtils.toFloatArray(new float[collection.size()], collection);
    }

    private static Object toFloatArray(Object array, Collection collection) {
        float[] fa = (float[])array;
        int i = 0;
        for (Object o : collection) {
            float f = ((Float)o).floatValue();
            fa[i++] = f;
        }
        return fa;
    }

    private static Object toDoubleArray(Collection collection) {
        return ArrayUtils.toDoubleArray(new double[collection.size()], collection);
    }

    private static Object toDoubleArray(Object array, Collection collection) {
        double[] da = (double[])array;
        int i = 0;
        for (Object o : collection) {
            double d = o instanceof Integer ? (double)((Integer)o).intValue() : (Double)o;
            da[i++] = d;
        }
        return da;
    }

    private static Object toBooleanArray(Collection collection) {
        return ArrayUtils.toBooleanArray(new boolean[collection.size()], collection);
    }

    private static Object toBooleanArray(Object array, Collection collection) {
        boolean[] ba = (boolean[])array;
        int i = 0;
        for (Object o : collection) {
            boolean b = (Boolean)o;
            ba[i++] = b;
        }
        return ba;
    }

    private static Object toCharacterArray(Collection collection) {
        return ArrayUtils.toCharacterArray(new char[collection.size()], collection);
    }

    private static Object toCharacterArray(Object array, Collection collection) {
        char[] ca = (char[])array;
        int i = 0;
        for (Object o : collection) {
            char c = ((Character)o).charValue();
            ca[i++] = c;
        }
        return ca;
    }

    private static Object toObjectArray(Class<?> type, Collection collection) {
        return collection.toArray((Object[])Array.newInstance(type, collection.size()));
    }

    private static Object toObjectArray(Object array, Collection collection) {
        Object[] oa = (Object[])array;
        int i = 0;
        for (Object o : collection) {
            oa[i++] = o;
        }
        return oa;
    }

    public static Class<?> getGenericType(Class<?> nested) {
        if (nested == Byte.TYPE) {
            nested = Byte.class;
        } else if (nested == Short.TYPE) {
            nested = Short.class;
        } else if (nested == Integer.TYPE) {
            nested = Integer.class;
        } else if (nested == Long.TYPE) {
            nested = Long.class;
        } else if (nested == Float.TYPE) {
            nested = Float.class;
        } else if (nested == Double.class) {
            nested = Double.class;
        } else if (nested == Boolean.TYPE) {
            nested = Boolean.class;
        } else if (nested == Character.class) {
            nested = Character.class;
        }
        return nested;
    }
}

