/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.red5.io.matroska.ParserUtils;
import org.red5.io.matroska.VINT;
import org.red5.io.matroska.dtd.Tag;

public class UnsignedIntegerTag
extends Tag {
    private long value;

    public UnsignedIntegerTag(String name, VINT id) throws IOException {
        super(name, id);
    }

    public UnsignedIntegerTag(String name, VINT id, VINT size, InputStream inputStream) throws IOException {
        super(name, id, size, inputStream);
    }

    @Override
    public void parse(InputStream inputStream) throws IOException {
        this.value = ParserUtils.parseInteger(inputStream, (int)this.getSize());
    }

    @Override
    protected void putValue(ByteBuffer bb) throws IOException {
        bb.put(ParserUtils.getBytes(this.value, this.getSize()));
    }

    public long getValue() {
        return this.value;
    }

    public UnsignedIntegerTag setValue(long value) {
        this.value = value;
        int length = 1;
        for (long v = value + 1L >> 8; v > 0L; v >>= 8) {
            length = (byte)(length + 1);
        }
        this.size = VINT.fromValue(length);
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + " = " + this.value;
    }
}

