/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.red5.io.matroska.ConverterException;
import org.red5.io.matroska.ParserUtils;
import org.red5.io.matroska.VINT;
import org.red5.io.matroska.dtd.Tag;

public class SimpleBlock
extends Tag {
    private VINT trackNumber;
    private long timeCode;
    private boolean keyFrame;
    private byte[] binary;

    public SimpleBlock(String name, VINT id) throws IOException {
        super(name, id);
    }

    public SimpleBlock(String name, VINT id, VINT size, InputStream inputStream) throws IOException {
        super(name, id, size, inputStream);
    }

    @Override
    public void parse(InputStream inputStream) throws IOException, ConverterException {
        this.trackNumber = ParserUtils.readVINT(inputStream);
        this.timeCode = ParserUtils.parseInteger(inputStream, 2);
        this.keyFrame = 128 == (inputStream.read() & 0x80);
        this.binary = ParserUtils.parseBinary(inputStream, (int)this.getSize() - 4);
    }

    @Override
    protected void putValue(ByteBuffer bb) throws IOException {
        bb.put(this.trackNumber.encode());
        bb.put(ParserUtils.getBytes(this.timeCode, 2L));
        bb.put((byte)(this.keyFrame ? 128 : 0));
        bb.put(this.binary);
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public long getTimeCode() {
        return this.timeCode;
    }

    public int getTrackNumber() {
        return (int)this.trackNumber.getValue();
    }

    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    @Override
    public String toString() {
        return super.toString() + " = binary " + this.binary.length;
    }
}

