/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.amf3.DataInput;
import org.red5.io.amf3.DataOutput;
import org.red5.io.amf3.IDataInput;
import org.red5.io.amf3.IDataOutput;
import org.red5.io.amf3.Input;
import org.red5.io.amf3.Output;

public class ByteArray
implements IDataInput,
IDataOutput {
    protected IoBuffer data;
    protected IDataInput dataInput;
    protected IDataOutput dataOutput;

    protected ByteArray(IoBuffer buffer, int length) {
        this.data = IoBuffer.allocate((int)length);
        this.data.setAutoExpand(true);
        byte[] tmp = new byte[length];
        buffer.get(tmp);
        this.data.put(tmp);
        this.data.flip();
        this.prepareIO();
    }

    public ByteArray() {
        this.data = IoBuffer.allocate((int)0);
        this.data.setAutoExpand(true);
        this.prepareIO();
    }

    protected void prepareIO() {
        Input input = new Input(this.data);
        input.enforceAMF3();
        this.dataInput = new DataInput(input);
        Output output = new Output(this.data);
        output.enforceAMF3();
        this.dataOutput = new DataOutput(output);
    }

    protected IoBuffer getData() {
        return this.data;
    }

    public int position() {
        return this.data.position();
    }

    public void position(int position) {
        this.data.position(position);
    }

    public int bytesAvailable() {
        return this.length() - this.position();
    }

    public int length() {
        return this.data.limit();
    }

    public void compress() {
        IoBuffer tmp = IoBuffer.allocate((int)0);
        tmp.setAutoExpand(true);
        byte[] tmpData = new byte[this.data.limit()];
        this.data.position(0);
        this.data.get(tmpData);
        try (DeflaterOutputStream deflater = new DeflaterOutputStream(tmp.asOutputStream(), new Deflater(9));){
            deflater.write(tmpData);
            deflater.finish();
        }
        catch (IOException e) {
            tmp.free();
            throw new RuntimeException("could not compress data", e);
        }
        this.data.free();
        this.data = tmp;
        this.data.flip();
        this.prepareIO();
    }

    public void uncompress() {
        this.data.position(0);
        byte[] buffer = new byte[8192];
        IoBuffer tmp = IoBuffer.allocate((int)0);
        tmp.setAutoExpand(true);
        try (InflaterInputStream inflater = new InflaterInputStream(this.data.asInputStream());){
            while (inflater.available() > 0) {
                int decompressed = inflater.read(buffer);
                if (decompressed <= 0) {
                    break;
                }
                tmp.put(buffer, 0, decompressed);
            }
        }
        catch (IOException e) {
            tmp.free();
            throw new RuntimeException("could not uncompress data", e);
        }
        this.data.free();
        this.data = tmp;
        this.data.flip();
        this.prepareIO();
    }

    @Override
    public ByteOrder getEndian() {
        return this.dataInput.getEndian();
    }

    @Override
    public boolean readBoolean() {
        return this.dataInput.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.dataInput.readByte();
    }

    @Override
    public void readBytes(byte[] bytes) {
        this.dataInput.readBytes(bytes);
    }

    @Override
    public void readBytes(byte[] bytes, int offset) {
        this.dataInput.readBytes(bytes, offset);
    }

    @Override
    public void readBytes(byte[] bytes, int offset, int length) {
        this.dataInput.readBytes(bytes, offset, length);
    }

    @Override
    public double readDouble() {
        return this.dataInput.readDouble();
    }

    @Override
    public float readFloat() {
        return this.dataInput.readFloat();
    }

    @Override
    public int readInt() {
        return this.dataInput.readInt();
    }

    @Override
    public String readMultiByte(int length, String charSet) {
        return this.dataInput.readMultiByte(length, charSet);
    }

    @Override
    public Object readObject() {
        this.prepareIO();
        return this.dataInput.readObject();
    }

    @Override
    public short readShort() {
        return this.dataInput.readShort();
    }

    @Override
    public String readUTF() {
        return this.dataInput.readUTF();
    }

    @Override
    public String readUTFBytes(int length) {
        return this.dataInput.readUTFBytes(length);
    }

    @Override
    public int readUnsignedByte() {
        return this.dataInput.readUnsignedByte();
    }

    @Override
    public long readUnsignedInt() {
        return this.dataInput.readUnsignedInt();
    }

    @Override
    public int readUnsignedShort() {
        return this.dataInput.readUnsignedShort();
    }

    @Override
    public void setEndian(ByteOrder endian) {
        this.dataInput.setEndian(endian);
        this.dataOutput.setEndian(endian);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.dataOutput.writeBoolean(value);
    }

    @Override
    public void writeByte(byte value) {
        this.dataOutput.writeByte(value);
    }

    @Override
    public void writeBytes(byte[] bytes) {
        this.dataOutput.writeBytes(bytes);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset) {
        this.dataOutput.writeBytes(bytes, offset);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int length) {
        this.dataOutput.writeBytes(bytes, offset, length);
    }

    @Override
    public void writeDouble(double value) {
        this.dataOutput.writeDouble(value);
    }

    @Override
    public void writeFloat(float value) {
        this.dataOutput.writeFloat(value);
    }

    @Override
    public void writeInt(int value) {
        this.dataOutput.writeInt(value);
    }

    @Override
    public void writeMultiByte(String value, String encoding) {
        this.dataOutput.writeMultiByte(value, encoding);
    }

    @Override
    public void writeObject(Object value) {
        this.prepareIO();
        this.dataOutput.writeObject(value);
    }

    @Override
    public void writeShort(short value) {
        this.dataOutput.writeShort(value);
    }

    @Override
    public void writeUTF(String value) {
        this.dataOutput.writeUTF(value);
    }

    @Override
    public void writeUTFBytes(String value) {
        this.dataOutput.writeUTFBytes(value);
    }

    @Override
    public void writeUnsignedInt(long value) {
        this.dataOutput.writeUnsignedInt(value);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArray other = (ByteArray)obj;
        return this.toString().equals(other.toString());
    }

    public String toString() {
        if (this.data != null) {
            int old = this.data.position();
            try {
                this.data.position(0);
                String string = this.data.asCharBuffer().toString();
                return string;
            }
            finally {
                this.data.position(old);
            }
        }
        return "";
    }
}

