/*
 * Decompiled with CFR 0.152.
 */
package org.red5.cache.impl;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.cache.ICacheStore;
import org.red5.cache.ICacheable;
import org.red5.cache.impl.CacheableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CacheImpl
implements ICacheStore,
ApplicationContextAware {
    protected static Logger log = LoggerFactory.getLogger(CacheImpl.class);
    private static volatile CacheImpl instance;
    private static final Map<String, SoftReference<? extends ICacheable>> CACHE;
    private static Map<String, Integer> registry;
    private static int capacity;
    private static volatile long cacheHit;
    private static volatile long cacheMiss;
    private static ApplicationContext applicationContext;

    private CacheImpl() {
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static CacheImpl getInstance() {
        return instance;
    }

    public void init() {
        log.info("Loading generic object cache");
        log.debug("Appcontext: {}", (Object)applicationContext.toString());
    }

    @Override
    public Iterator<String> getObjectNames() {
        return Collections.unmodifiableSet(CACHE.keySet()).iterator();
    }

    @Override
    public Iterator<SoftReference<? extends ICacheable>> getObjects() {
        return Collections.unmodifiableCollection(CACHE.values()).iterator();
    }

    public boolean offer(String key, IoBuffer obj) {
        return this.offer(key, new CacheableImpl(obj));
    }

    @Override
    public boolean offer(String name, Object obj) {
        boolean accepted = false;
        if (CACHE.size() < capacity) {
            SoftReference<? extends ICacheable> tmp = CACHE.get(name);
            if (null == tmp || null == tmp.get()) {
                ICacheable cacheable = null;
                cacheable = obj instanceof ICacheable ? (ICacheable)obj : new CacheableImpl(obj);
                cacheable.setName(name);
                registry.put(name, 1);
                SoftReference<ICacheable> value = new SoftReference<ICacheable>(cacheable);
                CACHE.put(name, value);
                accepted = true;
                log.info("{} has been added to the cache. Current size: {}", (Object)name, (Object)CACHE.size());
            }
        } else {
            log.warn("Cache has reached max element size: " + capacity);
        }
        return accepted;
    }

    @Override
    public void put(String name, Object obj) {
        if (obj instanceof ICacheable) {
            this.put(name, (ICacheable)obj);
        } else {
            this.put(name, new CacheableImpl(obj));
        }
    }

    protected void put(String name, ICacheable obj) {
        obj.setName(name);
        registry.put(name, 1);
        SoftReference<ICacheable> value = new SoftReference<ICacheable>(obj);
        CACHE.put(name, value);
        log.info(name + " has been added to the cache. Current size: " + CACHE.size());
    }

    @Override
    public ICacheable get(String name) {
        if (log.isDebugEnabled()) {
            log.debug("Looking up " + name + " in the cache. Current size: " + CACHE.size());
        }
        ICacheable ic = null;
        SoftReference<? extends ICacheable> sr = null;
        if (!CACHE.isEmpty() && null != (sr = CACHE.get(name))) {
            ic = sr.get();
            int requestCount = registry.get(name);
            registry.put(name, ++requestCount);
            ++cacheHit;
        } else {
            registry.put(name, 1);
            ++cacheMiss;
        }
        log.debug("Registry on get: {}", (Object)registry.toString());
        return ic;
    }

    @Override
    public boolean remove(ICacheable obj) {
        log.debug("Looking up {} in the cache. Current size: {}", (Object)obj.getName(), (Object)CACHE.size());
        return this.remove(obj.getName());
    }

    @Override
    public boolean remove(String name) {
        return CACHE.remove(name) != null;
    }

    public static long getCacheHit() {
        return cacheHit;
    }

    public static long getCacheMiss() {
        return cacheMiss;
    }

    @Override
    public void setMaxEntries(int max) {
        log.info("Setting max entries for this cache to {}", (Object)max);
        capacity = max;
    }

    @Override
    public void destroy() {
        try {
            registry.clear();
            registry = null;
            CACHE.clear();
        }
        catch (Exception e) {
            log.warn("Error on cache shutdown", (Throwable)e);
        }
    }

    static {
        capacity = 5;
        instance = new CacheImpl();
        CACHE = new HashMap<String, SoftReference<? extends ICacheable>>(3);
        registry = new HashMap<String, Integer>(3);
        applicationContext = null;
    }
}

