/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.matroska;

import java.util.BitSet;
import org.red5.io.matroska.ParserUtils;

public class VINT {
    public static final long MASK_BYTE_8 = 0xFFFFFFFFFFFFFFL;
    public static final long MASK_BYTE_4 = 0xFFFFFFFL;
    public static final long MASK_BYTE_3 = 0x1FFFFFL;
    public static final long MASK_BYTE_2 = 16383L;
    public static final long MASK_BYTE_1 = 127L;
    private long binary;
    private byte length;
    private long value;

    public VINT(long binary, byte length, long value) {
        if (binary == 0L) {
            BitSet bs = BitSet.valueOf(new long[]{value});
            bs.set(length * 8 - length);
            this.binary = bs.toLongArray()[0];
        } else {
            this.binary = binary;
        }
        this.length = length;
        this.value = value;
    }

    public byte getLength() {
        return this.length;
    }

    public long getBinary() {
        return this.binary;
    }

    public long getValue() {
        return this.value;
    }

    public byte[] encode() {
        return ParserUtils.getBytes(this.binary, this.length);
    }

    public String toString() {
        return String.format("%s(%s)", this.value, this.length);
    }

    public static VINT fromBinary(long binary) {
        BitSet bs = BitSet.valueOf(new long[]{binary});
        long mask = 127L;
        byte length = 1;
        if (bs.length() > 24) {
            mask = 0xFFFFFFFL;
            length = 4;
        } else if (bs.length() > 16) {
            mask = 0x1FFFFFL;
            length = 3;
        } else if (bs.length() > 8) {
            mask = 16383L;
            length = 2;
        }
        long value = binary & mask;
        return new VINT(binary, length, value);
    }

    public static VINT fromValue(long value) {
        BitSet bs = BitSet.valueOf(new long[]{value});
        byte length = (byte)(1 + bs.length() / 8);
        if (bs.length() == length * 8) {
            length = (byte)(length + 1);
        }
        bs.set(length * 8 - length);
        long binary = bs.toLongArray()[0];
        return new VINT(binary, length, value);
    }
}

