/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.extractors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.scribe.exceptions.OAuthException;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.model.Token;
import org.scribe.utils.Preconditions;

public class StravaJsonExtractor
implements AccessTokenExtractor {
    private static final String OAUTH_EXCEPTION_INVALID_TOKEN_MESSAGE = "Response body is incorrect. Can't extract a token from this: '";
    private ObjectMapper objectMapper = new ObjectMapper();

    public StravaJsonExtractor() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Token extract(String response) {
        Preconditions.checkEmptyString((String)response, (String)"Response body is incorrect. Can't extract a token from an empty string");
        try {
            StravaAccessToken stravaAccessToken = (StravaAccessToken)this.objectMapper.readValue(response, StravaAccessToken.class);
            if (stravaAccessToken == null || stravaAccessToken.getAccessToken() == null) {
                throw new OAuthException(OAUTH_EXCEPTION_INVALID_TOKEN_MESSAGE + response + "'", null);
            }
            String accessTokenValue = stravaAccessToken.getAccessToken();
            return new Token(accessTokenValue, "", response);
        }
        catch (IOException e) {
            throw new OAuthException(OAUTH_EXCEPTION_INVALID_TOKEN_MESSAGE + response + "'", null);
        }
    }

    private static class StravaAccessToken {
        @JsonProperty(value="access_token")
        private String accessToken;

        private StravaAccessToken() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }
    }
}

