/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.BaseOAuth10Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.twitter.TwitterProfile;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.builder.api.TwitterApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth10aServiceImpl;

public class TwitterClient
extends BaseOAuth10Client<TwitterProfile> {
    private boolean alwaysConfirmAuthorization = false;

    public TwitterClient() {
    }

    public TwitterClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected TwitterClient newClient() {
        return new TwitterClient();
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        Object api = !this.alwaysConfirmAuthorization ? new TwitterApi.Authenticate() : new TwitterApi();
        this.service = new ProxyOAuth10aServiceImpl((DefaultApi10a)api, new OAuthConfig(this.key, this.secret, this.callbackUrl, SignatureType.Header, null, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl(Token accessToken) {
        return "https://api.twitter.com/1.1/account/verify_credentials.json";
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        String denied = context.getRequestParameter("denied");
        return CommonHelper.isNotBlank((String)denied);
    }

    @Override
    protected TwitterProfile extractUserProfile(String body) {
        TwitterProfile profile = new TwitterProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.get(json, "id"));
            for (String attribute : OAuthAttributesDefinitions.twitterDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
        }
        return profile;
    }

    public boolean isAlwaysConfirmAuthorization() {
        return this.alwaysConfirmAuthorization;
    }

    public void setAlwaysConfirmAuthorization(boolean alwaysConfirmAuthorization) {
        this.alwaysConfirmAuthorization = alwaysConfirmAuthorization;
    }
}

