/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.ns;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.ow2.carol.jndi.ns.AbsRegistry;
import org.ow2.carol.jndi.ns.NameService;
import org.ow2.carol.jndi.ns.NameServiceException;
import org.ow2.carol.jndi.registry.RegistryCreator;
import org.ow2.carol.rmi.util.PortNumber;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.ConfigurationUtil;
import org.ow2.carol.util.configuration.TraceCarol;

public class IRMIRegistry
extends AbsRegistry
implements NameService {
    private static final int DEFAULT_PORT_NUMBER = 1098;
    private static int objectPort = 0;
    private InetAddress registryInetAddress = null;
    private static Registry registry = null;

    public IRMIRegistry() {
        super(1098);
    }

    public void start() throws NameServiceException {
        block16: {
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("IRMIRegistry.start() on port:" + this.getPort());
            }
            try {
                if (Boolean.getBoolean("carol.server.mode")) {
                    if (this.getConfigProperties() != null) {
                        String propertyName = "carol.irmi.server.port";
                        objectPort = PortNumber.strToint(this.getConfigProperties().getProperty(propertyName, "0"), propertyName);
                        propertyName = "carol.irmi.interfaces.bind.single";
                        boolean useSingleItf = Boolean.valueOf(this.getConfigProperties().getProperty(propertyName, "false"));
                        if (useSingleItf) {
                            String url = this.getConfigProperties().getProperty("carol.irmi.url");
                            this.registryInetAddress = InetAddress.getByName(ConfigurationUtil.getHostOfUrl(url));
                        }
                    } else {
                        TraceCarol.debugCarol("No properties 'carol.irmi.server.port' defined in carol.properties file.");
                    }
                }
                if (!this.isStarted()) {
                    if (objectPort > 0) {
                        TraceCarol.infoCarol("Using IRMI fixed server port number '" + objectPort + "'.");
                    }
                    if (this.registryInetAddress != null) {
                        TraceCarol.infoCarol("Using Specific address to bind registry '" + this.registryInetAddress + "'.");
                    }
                    if (this.getPort() >= 0) {
                        String protocol = null;
                        try {
                            protocol = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
                        }
                        catch (Exception e) {
                            protocol = null;
                        }
                        if (protocol == null || protocol.equals("")) {
                            TraceCarol.infoCarol("Unknown protocol - setting irmi");
                            protocol = "irmi";
                        }
                        registry = RegistryCreator.createRegistry(this.getPort(), objectPort, this.registryInetAddress, protocol);
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            public void run() {
                                try {
                                    IRMIRegistry.this.stop();
                                }
                                catch (Exception e) {
                                    TraceCarol.error("IRMIRegistry ShutdownHook problem", e);
                                }
                            }
                        });
                        break block16;
                    }
                    if (TraceCarol.isDebugJndiCarol()) {
                        TraceCarol.debugJndiCarol("Can't start IRMIRegistry, port=" + this.getPort() + " is < 0");
                    }
                    break block16;
                }
                if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("IRMIRegistry is already start on port:" + this.getPort());
                }
            }
            catch (Exception e) {
                throw new NameServiceException("can not start rmi registry: " + e);
            }
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("IRMIRegistry.stop()");
        }
        try {
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
            }
            registry = null;
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop rmi registry: " + e);
        }
    }

    public static boolean isLocal() {
        return registry != null;
    }

    public boolean isStarted() {
        if (registry != null) {
            return true;
        }
        try {
            if (this.registryInetAddress != null) {
                LocateRegistry.getRegistry(this.registryInetAddress.getHostAddress(), this.getPort()).list();
            } else {
                LocateRegistry.getRegistry(this.getPort()).list();
            }
        }
        catch (RemoteException re) {
            return false;
        }
        return true;
    }

    public static Registry getRegistry() {
        return registry;
    }
}

