/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.ops4j.io.StreamUtils;
import org.ops4j.io.ZipExploder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(ZipInstaller.class);
    private URL zipUrl;
    private String installRoot;

    public ZipInstaller(URL zipUrl, String installRoot) {
        this.zipUrl = zipUrl;
        this.installRoot = installRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAndInstall() throws IOException {
        File installDir = new File(this.installRoot);
        installDir.mkdirs();
        File tempFile = File.createTempFile("pax-exam", ".zip");
        FileOutputStream os = null;
        LOG.info("downloading {} to {}", (Object)this.zipUrl, (Object)tempFile);
        try {
            os = new FileOutputStream(tempFile);
            StreamUtils.copyStream((InputStream)this.zipUrl.openStream(), (OutputStream)os, (boolean)true);
            LOG.info("unzipping into {}", (Object)this.installRoot);
            ZipExploder exploder = new ZipExploder();
            exploder.processFile(tempFile.getAbsolutePath(), this.installRoot);
        }
        finally {
            tempFile.delete();
        }
    }
}

