/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options.extra;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;

public class ProfileOption
implements Option {
    private final String m_name;
    private String m_version;

    public ProfileOption(String name) {
        this(name, null);
    }

    public ProfileOption(String name, String version) {
        NullArgumentException.validateNotEmpty((String)name, (boolean)true, (String)"Profile name");
        if (version != null) {
            NullArgumentException.validateNotEmpty((String)version, (boolean)true, (String)"Profile version");
        }
        this.m_name = name;
        this.m_version = version;
    }

    public String getProfile() {
        return this.m_name + (this.m_version == null ? "" : "/" + this.m_version);
    }

    public ProfileOption version(String version) {
        if (version != null) {
            NullArgumentException.validateNotEmpty((String)version, (boolean)true, (String)"Version");
        }
        this.m_version = version;
        return this;
    }

    public ProfileOption versionAsInProject() {
        return this.version(MavenUtils.asInProject().getVersion("org.ops4j.pax.runner.profiles", this.getProfile()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProfileOption");
        sb.append("{name='").append(this.m_name).append('\'');
        if (this.m_version != null) {
            sb.append(",version='").append(this.m_version).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

