/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.cache.dao.impl.provider;

import java.util.concurrent.ConcurrentHashMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.cache.dao.CacheResult;
import org.nutz.plugins.cache.dao.CachedNutDaoExecutor;
import org.nutz.plugins.cache.dao.impl.provider.AbstractDaoCacheProvider;
import org.nutz.repo.cache.simple.LRUCache;

public class MemoryDaoCacheProvider
extends AbstractDaoCacheProvider {
    private static final Log log = Logs.get();
    protected ConcurrentHashMap<String, LRUCache<String, Object>> caches = new ConcurrentHashMap();
    protected int cacheSize = 1000;

    @Override
    public Object get(String cacheName, String key) {
        LRUCache<String, Object> cache = this._getCache(cacheName, false);
        if (cache != null) {
            return this.getSerializer().back(cache.get((Object)key));
        }
        return CacheResult.NOT_FOUNT;
    }

    @Override
    public boolean put(String cacheName, String key, Object obj) {
        Object data = this.getSerializer().from(obj);
        if (data == null) {
            if (CachedNutDaoExecutor.DEBUG) {
                log.debug((Object)"Serializer.from >> NULL");
            }
            return false;
        }
        if (CachedNutDaoExecutor.DEBUG) {
            log.debugf("CacheName=%s, KEY=%s", new Object[]{cacheName, key});
        }
        this._getCache(cacheName, true).put((Object)key, data);
        return true;
    }

    @Override
    public void clear(String cacheName) {
        LRUCache<String, Object> cache = this._getCache(cacheName, false);
        if (cache != null) {
            cache.clear();
        }
    }

    public LRUCache<String, Object> _getCache(String cacheName, boolean create) {
        LRUCache cache = this.caches.get(cacheName);
        if (cache == null) {
            if (!create) {
                return null;
            }
            cache = new LRUCache(this.cacheSize);
            this.caches.put(cacheName, (LRUCache<String, Object>)cache);
        }
        return cache;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }
}

