/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps.cypher;

import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Map;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.query.clientconnection.ShellConnectionInfo;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.OutputAsWriter;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Start
extends TransactionProvidingApp {
    private QueryExecutionEngine engine;

    @Override
    public String getDescription() {
        String className = this.getClass().getSimpleName().toUpperCase();
        return MessageFormat.format("Executes a Cypher query. Usage: {0} <rest of query>;\nExample: MATCH (me)-[:KNOWS]->(you) RETURN you.name;\nwhere '{'self'}' will be replaced with the current location in the graph.Please, note that the query must end with a semicolon. Other parameters are\ntaken from shell variables, see ''help export''.", className);
    }

    @Override
    public Continuation execute(AppCommandParser parser, Session session, Output out) throws Exception {
        String query = parser.getLine().trim();
        if (this.isComplete(query)) {
            if (this.getEngine().isPeriodicCommit(query)) {
                return this.exec(parser, session, out);
            }
            return super.execute(parser, session, out);
        }
        return Continuation.INPUT_INCOMPLETE;
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        String query = parser.getLine().trim();
        if (this.isComplete(query)) {
            long startTime = System.currentTimeMillis();
            try {
                Result result = this.getResult(this.trimQuery(query), session);
                this.handleResult(out, result, startTime);
            }
            catch (QueryExecutionKernelException e) {
                this.handleException(out, e, startTime);
                return Continuation.EXCEPTION_CAUGHT;
            }
            return Continuation.INPUT_COMPLETE;
        }
        return Continuation.INPUT_INCOMPLETE;
    }

    private Result getResult(String query, Session session) throws ShellException, RemoteException, QueryExecutionKernelException {
        Map<String, Object> parameters = this.getParameters(session);
        TransactionalContext tc = this.createTransactionContext(query, parameters, session);
        return this.getEngine().executeQuery(query, parameters, tc);
    }

    private String trimQuery(String query) {
        return query.substring(0, query.lastIndexOf(";"));
    }

    protected void handleResult(Output out, Result result, long startTime) throws RemoteException, ShellException {
        this.printResult(out, result, startTime);
        result.close();
    }

    private void printResult(Output out, Result result, long startTime) throws RemoteException {
        result.writeAsStringTo(new PrintWriter(new OutputAsWriter(out)));
        out.println((Serializable)((Object)(this.now() - startTime + " ms")));
        if (result.getQueryExecutionType().requestedExecutionPlanDescription()) {
            out.println();
            out.println((Serializable)((Object)result.getExecutionPlanDescription().toString()));
        }
    }

    private void handleException(Output out, QueryExecutionKernelException exception, long startTime) throws RemoteException {
        out.println((Serializable)((Object)(this.now() - startTime + " ms")));
        out.println();
        out.println((Serializable)((Object)("WARNING: " + exception.getMessage())));
    }

    private Map<String, Object> getParameters(Session session) throws ShellException {
        try {
            NodeOrRelationship self = this.getCurrent(session);
            session.set("self", self.isNode() ? self.asNode() : self.asRelationship());
        }
        catch (ShellException shellException) {
            // empty catch block
        }
        return session.asMap();
    }

    private boolean isComplete(String query) {
        return query.endsWith(";");
    }

    protected QueryExecutionEngine getEngine() {
        if (this.engine == null) {
            this.engine = (QueryExecutionEngine)this.getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        }
        return this.engine;
    }

    private DependencyResolver getDependencyResolver() {
        return this.getServer().getDb().getDependencyResolver();
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    private TransactionalContext createTransactionContext(String queryText, Map<String, Object> queryParameters, Session session) {
        DependencyResolver dependencyResolver = this.getDependencyResolver();
        GraphDatabaseQueryService graph = (GraphDatabaseQueryService)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class);
        TransactionalContextFactory contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)graph, (PropertyContainerLocker)new PropertyContainerLocker());
        InternalTransaction transaction = graph.beginTransaction(KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED);
        return contextFactory.newContext((ClientConnectionInfo)new ShellConnectionInfo(session.getId()), transaction, queryText, queryParameters);
    }
}

