/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.regex.Pattern;
import org.neo4j.shell.ShellException;

public class Variables {
    public static final String WORKING_DIR_KEY = "WORKING_DIR";
    public static final String CURRENT_KEY = "CURRENT_DIR";
    private static final Pattern IDENTIFIER = Pattern.compile("^\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*$");
    public static final String TX_COUNT = "TX_COUNT";
    public static final String PROMPT_KEY = "PS1";
    public static final String STACKTRACES_KEY = "STACKTRACES";
    public static final String TITLE_KEYS_KEY = "TITLE_KEYS";
    public static final String TITLE_MAX_LENGTH = "TITLE_MAX_LENGTH";

    public static void checkIsValidVariableName(String key) throws ShellException {
        if (!Variables.isIdentifier(key)) {
            throw new ShellException(key + " is no valid variable name. May only contain alphanumeric characters and underscores.");
        }
    }

    public static boolean isIdentifier(String key) {
        return IDENTIFIER.matcher(key).matches();
    }
}

