/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.shell.Output;

public class ColumnPrinter {
    private final Column rawColumn;
    private final List<Column> columns = new ArrayList<Column>();

    public ColumnPrinter(String ... columnPrefixes) {
        for (String prefix : columnPrefixes) {
            this.columns.add(new Column(prefix));
        }
        this.rawColumn = new RawColumn(columnPrefixes[0].length());
    }

    public void add(Object ... columns) {
        Iterator<Column> columnIterator = this.columns.iterator();
        this.rawColumn.add("");
        for (Object column : columns) {
            columnIterator.next().add(column.toString());
        }
        if (columnIterator.hasNext()) {
            throw new IllegalArgumentException("Invalid column count " + columns.length + ", expected " + this.columns.size());
        }
    }

    public void addRaw(String string) {
        this.rawColumn.add(string);
        for (Column col : this.columns) {
            col.add("");
        }
    }

    public void print(Output out) throws RemoteException {
        Column firstColumn = this.columns.get(0);
        for (int line = 0; line < firstColumn.size(); ++line) {
            if (!this.rawColumn.print(out, line)) {
                firstColumn.print(out, line);
                for (int col = 1; col < this.columns.size(); ++col) {
                    this.columns.get(col).print(out, line);
                }
            }
            out.println();
        }
    }

    private static String multiply(String string, int count) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(string);
        }
        return builder.toString();
    }

    private static class RawColumn
    extends Column {
        RawColumn(int indentation) {
            super(ColumnPrinter.multiply(" ", indentation));
        }

        @Override
        boolean print(Output out, int i) throws RemoteException {
            String value = (String)this.cells.get(i);
            if (value.length() > 0) {
                for (String line : value.split(System.lineSeparator())) {
                    out.print((Serializable)((Object)(this.prefix + "|" + line + System.lineSeparator())));
                }
                return true;
            }
            return false;
        }
    }

    private static class Column {
        private int widest = 0;
        protected final List<String> cells = new ArrayList<String>();
        protected final String prefix;

        Column(String prefix) {
            this.prefix = prefix;
        }

        void add(String cell) {
            this.cells.add(cell);
            this.widest = Math.max(this.widest, cell.length());
        }

        int size() {
            return this.cells.size();
        }

        boolean print(Output out, int i) throws RemoteException {
            String value = this.cells.get(i);
            out.print((Serializable)((Object)(this.prefix + value + ColumnPrinter.multiply(" ", this.widest - value.length() + 1))));
            return value.length() > 0;
        }
    }
}

