/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

public class FreeIdKeeper
implements Closeable {
    public static final long NO_RESULT = -1L;
    public static final int ID_ENTRY_SIZE = 8;
    private final LinkedList<Long> freeIds = new LinkedList();
    private final LinkedList<Long> readFromDisk = new LinkedList();
    private final StoreChannel channel;
    private final int threshold;
    private final boolean aggressiveReuse;
    private long defraggedIdCount;
    private final long lowWatermarkForChannelPosition;
    private long maxReadPosition;
    private long readPosition;

    public FreeIdKeeper(StoreChannel channel, int threshold, boolean aggressiveReuse, int initialPosition) throws IOException {
        this.channel = channel;
        this.threshold = threshold;
        this.aggressiveReuse = aggressiveReuse;
        this.readPosition = this.lowWatermarkForChannelPosition = (long)initialPosition;
        this.maxReadPosition = this.channel.size();
        this.defraggedIdCount = (this.maxReadPosition - this.lowWatermarkForChannelPosition) / 8L;
    }

    public void freeId(long id) {
        this.freeIds.add(id);
        ++this.defraggedIdCount;
        if (this.freeIds.size() >= this.threshold) {
            this.writeIdBatch(ByteBuffer.allocate(this.threshold * 8));
        }
    }

    public long getId() {
        long result;
        if (this.freeIds.size() > 0 && this.aggressiveReuse) {
            result = this.freeIds.poll();
            --this.defraggedIdCount;
        } else if (this.readFromDisk.size() > 0) {
            result = this.readFromDisk.removeFirst();
            --this.defraggedIdCount;
        } else if (this.defraggedIdCount > 0L && this.canReadMoreIdBatches()) {
            this.readIdBatch();
            result = this.readFromDisk.removeFirst();
            --this.defraggedIdCount;
        } else {
            result = -1L;
        }
        return result;
    }

    public long getCount() {
        return this.defraggedIdCount;
    }

    private boolean canReadMoreIdBatches() {
        assert ((this.maxReadPosition - this.readPosition) % 8L == 0L) : String.format("maxReadPosition %d, readPosition %d do not contain an integral number of entries", this.maxReadPosition, this.readPosition);
        return this.readPosition < this.maxReadPosition;
    }

    private void readIdBatch() {
        if (!this.canReadMoreIdBatches()) {
            return;
        }
        try {
            int howMuchToRead = (int)Math.min((long)(this.threshold * 8), this.maxReadPosition - this.readPosition);
            assert (howMuchToRead % 8 == 0) : "reads should happen in multiples of ID_ENTRY_SIZE, instead was " + howMuchToRead;
            ByteBuffer readBuffer = ByteBuffer.allocate(howMuchToRead);
            this.positionChannel(this.readPosition);
            int bytesRead = this.channel.read(readBuffer);
            this.readPosition += (long)bytesRead;
            assert (this.channel.position() <= this.maxReadPosition);
            readBuffer.flip();
            assert (bytesRead % 8 == 0);
            int idsRead = bytesRead / 8;
            for (int i = 0; i < idsRead; ++i) {
                long id = readBuffer.getLong();
                if (id == -1L) continue;
                this.readFromDisk.add(id);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed reading defragged id batch", e);
        }
    }

    @Override
    public void close() throws IOException {
        ByteBuffer writeBuffer = ByteBuffer.allocate(this.threshold * 8);
        this.writeIdBatch(writeBuffer);
        while (!this.readFromDisk.isEmpty()) {
            this.freeIds.add(this.readFromDisk.removeFirst());
        }
        this.writeIdBatch(writeBuffer);
        this.defragReusableIdsInFile(writeBuffer);
        this.channel.force(false);
    }

    private void writeIdBatch(ByteBuffer writeBuffer) {
        try {
            this.positionChannel(this.channel.size());
            writeBuffer.clear();
            while (!this.freeIds.isEmpty()) {
                long id = this.freeIds.removeFirst();
                if (id == -1L) continue;
                writeBuffer.putLong(id);
                if (writeBuffer.position() != writeBuffer.capacity()) continue;
                writeBuffer.flip();
                while (writeBuffer.hasRemaining()) {
                    this.channel.write(writeBuffer);
                }
                writeBuffer.clear();
            }
            writeBuffer.flip();
            while (writeBuffer.hasRemaining()) {
                this.channel.write(writeBuffer);
            }
            if (this.aggressiveReuse) {
                this.maxReadPosition = this.channel.size();
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to write defragged id  batch", e);
        }
    }

    private void positionChannel(long newPosition) throws IOException {
        if (newPosition < this.lowWatermarkForChannelPosition) {
            throw new IllegalStateException(String.format("%d is less than the lowest position (%d) this id keeper can go", newPosition, this.lowWatermarkForChannelPosition));
        }
        this.channel.position(newPosition);
    }

    private void defragReusableIdsInFile(ByteBuffer writeBuffer) throws IOException {
        if (this.readPosition > this.lowWatermarkForChannelPosition) {
            int bytesRead;
            long writePosition = this.lowWatermarkForChannelPosition;
            long position = Math.min(this.readPosition, this.maxReadPosition);
            do {
                writeBuffer.clear();
                this.channel.position(position);
                bytesRead = this.channel.read(writeBuffer);
                position += (long)bytesRead;
                writeBuffer.flip();
                this.channel.position(writePosition);
                writePosition += (long)this.channel.write(writeBuffer);
            } while (bytesRead > 0);
            this.channel.truncate(writePosition);
        }
    }
}

