/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.HighestTransactionId;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.standard.MetaDataRecordFormat;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.CappedLogger;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.time.Clocks;

public class MetaDataStore
extends CommonAbstractStore<MetaDataRecord, NoStoreHeader>
implements TransactionIdStore,
LogVersionRepository {
    public static final String TYPE_DESCRIPTOR = "NeoStore";
    public static final long FIELD_NOT_INITIALIZED = Long.MIN_VALUE;
    public static final String DEFAULT_NAME = "neostore";
    private volatile long creationTimeField = Long.MIN_VALUE;
    private volatile long randomNumberField = Long.MIN_VALUE;
    private volatile long versionField = Long.MIN_VALUE;
    private final AtomicLong lastCommittingTxField = new AtomicLong(Long.MIN_VALUE);
    private volatile long storeVersionField = Long.MIN_VALUE;
    private volatile long graphNextPropField = Long.MIN_VALUE;
    private volatile long latestConstraintIntroducingTxField = Long.MIN_VALUE;
    private volatile long upgradeTxIdField = Long.MIN_VALUE;
    private volatile long upgradeTxChecksumField = Long.MIN_VALUE;
    private volatile long upgradeTimeField = Long.MIN_VALUE;
    private volatile long upgradeCommitTimestampField = Long.MIN_VALUE;
    private volatile TransactionId upgradeTransaction = new TransactionId(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
    private final HighestTransactionId highestCommittedTransaction = new HighestTransactionId(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
    private final OutOfOrderSequence lastClosedTx = new ArrayQueueOutOfOrderSequence(-1L, 200, new long[2]);
    private final Object upgradeTimeLock = new Object();
    private final Object creationTimeLock = new Object();
    private final Object randomNumberLock = new Object();
    private final Object upgradeTransactionLock = new Object();
    private final Object logVersionLock = new Object();
    private final Object storeVersionLock = new Object();
    private final Object graphNextPropLock = new Object();
    private final Object lastConstraintIntroducingTxLock = new Object();
    private final Object transactionCommittedLock = new Object();
    private final Object transactionClosedLock = new Object();
    private final CappedLogger transactionCloseWaitLogger;

    MetaDataStore(File fileName, Config conf, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormat<MetaDataRecord> recordFormat, String storeVersion, OpenOption ... openOptions) {
        super(fileName, conf, IdType.NEOSTORE_BLOCK, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormat, NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, storeVersion, openOptions);
        this.transactionCloseWaitLogger = new CappedLogger(logProvider.getLog(MetaDataStore.class));
        this.transactionCloseWaitLogger.setTimeLimit(30L, TimeUnit.SECONDS, Clocks.systemClock());
    }

    @Override
    protected void initialiseNewStoreFile(PagedFile file) throws IOException {
        super.initialiseNewStoreFile(file);
        long storeVersionAsLong = MetaDataStore.versionStringToLong(this.storeVersion);
        StoreId storeId = new StoreId(storeVersionAsLong);
        this.storeFile = file;
        this.setCreationTime(storeId.getCreationTime());
        this.setRandomNumber(storeId.getRandomId());
        this.setUpgradeTime(storeId.getCreationTime());
        this.setUpgradeTransaction(1L, 0L, 0L);
        this.setCurrentLogVersion(0L);
        this.setLastCommittedAndClosedTransactionId(1L, 0L, 0L, 16L, 0L);
        this.setStoreVersion(storeVersionAsLong);
        this.setGraphNextProp(-1L);
        this.setLatestConstraintIntroducingTx(0L);
        this.flush();
        this.storeFile = null;
    }

    @Override
    public void setLastCommittedAndClosedTransactionId(long transactionId, long checksum, long commitTimestamp, long byteOffset, long logVersion) {
        this.assertNotClosed();
        this.setRecord(Position.LAST_TRANSACTION_ID, transactionId);
        this.setRecord(Position.LAST_TRANSACTION_CHECKSUM, checksum);
        this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, logVersion);
        this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, byteOffset);
        this.setRecord(Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, commitTimestamp);
        this.checkInitialized(this.lastCommittingTxField.get());
        this.lastCommittingTxField.set(transactionId);
        this.lastClosedTx.set(transactionId, new long[]{logVersion, byteOffset});
        this.highestCommittedTransaction.set(transactionId, checksum, commitTimestamp);
    }

    public static long setRecord(PageCache pageCache, File neoStore, Position position, long value) throws IOException {
        long previousValue = Long.MIN_VALUE;
        int pageSize = MetaDataStore.getPageSize(pageCache);
        try (PagedFile pagedFile = pageCache.map(neoStore, pageSize, new OpenOption[0]);){
            int offset = MetaDataStore.offset(position);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                if (cursor.next()) {
                    cursor.setOffset(offset);
                    byte inUse = cursor.getByte();
                    long record = cursor.getLong();
                    if (inUse == Record.IN_USE.byteValue()) {
                        previousValue = record;
                    }
                    cursor.setOffset(offset);
                    cursor.putByte(Record.IN_USE.byteValue());
                    cursor.putLong(value);
                    if (cursor.checkAndClearBoundsFlag()) {
                        MetaDataRecord neoStoreRecord = new MetaDataRecord();
                        neoStoreRecord.setId(position.id);
                        throw new UnderlyingStorageException(MetaDataStore.buildOutOfBoundsExceptionMessage(neoStoreRecord, 0L, offset, 9, pageSize, neoStore.getAbsolutePath()));
                    }
                }
            }
        }
        return previousValue;
    }

    private static int offset(Position position) {
        return 9 * position.id;
    }

    public static long getRecord(PageCache pageCache, File neoStore, Position position) throws IOException {
        long value;
        block27: {
            MetaDataRecordFormat format = new MetaDataRecordFormat();
            int pageSize = MetaDataStore.getPageSize(pageCache);
            value = -1L;
            try (PagedFile pagedFile = pageCache.map(neoStore, pageSize, new OpenOption[0]);){
                if (pagedFile.getLastPageId() < 0L) break block27;
                try (PageCursor cursor = pagedFile.io(0L, 1);){
                    if (cursor.next()) {
                        MetaDataRecord record = new MetaDataRecord();
                        record.setId(position.id);
                        do {
                            format.read(record, cursor, RecordLoad.CHECK, 9);
                            value = record.inUse() ? record.getValue() : -1L;
                        } while (cursor.shouldRetry());
                        if (cursor.checkAndClearBoundsFlag()) {
                            int offset = MetaDataStore.offset(position);
                            throw new UnderlyingStorageException(MetaDataStore.buildOutOfBoundsExceptionMessage(record, 0L, offset, 9, pageSize, neoStore.getAbsolutePath()));
                        }
                    }
                }
            }
        }
        return value;
    }

    static int getPageSize(PageCache pageCache) {
        return pageCache.pageSize() - pageCache.pageSize() % 9;
    }

    public StoreId getStoreId() {
        return new StoreId(this.getCreationTime(), this.getRandomNumber(), this.getStoreVersion(), this.getUpgradeTime(), this.upgradeTxIdField);
    }

    public static StoreId getStoreId(PageCache pageCache, File neoStore) throws IOException {
        return new StoreId(MetaDataStore.getRecord(pageCache, neoStore, Position.TIME), MetaDataStore.getRecord(pageCache, neoStore, Position.RANDOM_NUMBER), MetaDataStore.getRecord(pageCache, neoStore, Position.STORE_VERSION), MetaDataStore.getRecord(pageCache, neoStore, Position.UPGRADE_TIME), MetaDataStore.getRecord(pageCache, neoStore, Position.UPGRADE_TRANSACTION_ID));
    }

    public long getUpgradeTime() {
        this.assertNotClosed();
        this.checkInitialized(this.upgradeTimeField);
        return this.upgradeTimeField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgradeTime(long time) {
        Object object = this.upgradeTimeLock;
        synchronized (object) {
            this.setRecord(Position.UPGRADE_TIME, time);
            this.upgradeTimeField = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgradeTransaction(long id, long checksum, long timestamp) {
        long pageId = this.pageIdForRecord(Position.UPGRADE_TRANSACTION_ID.id);
        assert (pageId == this.pageIdForRecord(Position.UPGRADE_TRANSACTION_CHECKSUM.id));
        Object object = this.upgradeTransactionLock;
        synchronized (object) {
            try (PageCursor cursor = this.storeFile.io(pageId, 2);){
                if (!cursor.next()) {
                    throw new UnderlyingStorageException("Could not access MetaDataStore page " + pageId);
                }
                this.setRecord(cursor, Position.UPGRADE_TRANSACTION_ID, id);
                this.setRecord(cursor, Position.UPGRADE_TRANSACTION_CHECKSUM, checksum);
                this.setRecord(cursor, Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, timestamp);
                this.upgradeTxIdField = id;
                this.upgradeTxChecksumField = checksum;
                this.upgradeCommitTimestampField = timestamp;
                this.upgradeTransaction = new TransactionId(id, checksum, timestamp);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }
    }

    public long getCreationTime() {
        this.assertNotClosed();
        this.checkInitialized(this.creationTimeField);
        return this.creationTimeField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreationTime(long time) {
        Object object = this.creationTimeLock;
        synchronized (object) {
            this.setRecord(Position.TIME, time);
            this.creationTimeField = time;
        }
    }

    public long getRandomNumber() {
        this.assertNotClosed();
        this.checkInitialized(this.randomNumberField);
        return this.randomNumberField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRandomNumber(long nr) {
        Object object = this.randomNumberLock;
        synchronized (object) {
            this.setRecord(Position.RANDOM_NUMBER, nr);
            this.randomNumberField = nr;
        }
    }

    @Override
    public long getCurrentLogVersion() {
        this.assertNotClosed();
        this.checkInitialized(this.versionField);
        return this.versionField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentLogVersion(long version) {
        Object object = this.logVersionLock;
        synchronized (object) {
            this.setRecord(Position.LOG_VERSION, version);
            this.versionField = version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastTransactionCommitTimestamp(long timestamp) {
        Object object = this.transactionCommittedLock;
        synchronized (object) {
            this.setRecord(Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, timestamp);
            TransactionId transactionId = this.highestCommittedTransaction.get();
            this.highestCommittedTransaction.set(transactionId.transactionId(), transactionId.checksum(), timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long incrementAndGetVersion() {
        long version;
        long pageId = this.pageIdForRecord(Position.LOG_VERSION.id);
        Object object = this.logVersionLock;
        synchronized (object) {
            try (PageCursor cursor = this.storeFile.io(pageId, 2);){
                if (cursor.next()) {
                    this.incrementVersion(cursor);
                }
                version = this.versionField;
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }
        this.flush();
        return version;
    }

    private void incrementVersion(PageCursor cursor) throws IOException {
        if (!cursor.isWriteLocked()) {
            throw new IllegalArgumentException("Cannot increment log version on page cursor that is not write-locked");
        }
        int offset = Position.LOG_VERSION.id * this.getRecordSize() + 1;
        long value = cursor.getLong(offset) + 1L;
        cursor.putLong(offset, value);
        this.checkForDecodingErrors(cursor, Position.LOG_VERSION.id, RecordLoad.NORMAL);
        this.versionField = value;
    }

    public long getStoreVersion() {
        this.assertNotClosed();
        this.checkInitialized(this.storeVersionField);
        return this.storeVersionField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoreVersion(long version) {
        Object object = this.storeVersionLock;
        synchronized (object) {
            this.setRecord(Position.STORE_VERSION, version);
            this.storeVersionField = version;
        }
    }

    public long getGraphNextProp() {
        this.assertNotClosed();
        this.checkInitialized(this.graphNextPropField);
        return this.graphNextPropField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraphNextProp(long propId) {
        Object object = this.graphNextPropLock;
        synchronized (object) {
            this.setRecord(Position.FIRST_GRAPH_PROPERTY, propId);
            this.graphNextPropField = propId;
        }
    }

    public long getLatestConstraintIntroducingTx() {
        this.assertNotClosed();
        this.checkInitialized(this.latestConstraintIntroducingTxField);
        return this.latestConstraintIntroducingTxField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLatestConstraintIntroducingTx(long latestConstraintIntroducingTx) {
        Object object = this.lastConstraintIntroducingTxLock;
        synchronized (object) {
            this.setRecord(Position.LAST_CONSTRAINT_TRANSACTION, latestConstraintIntroducingTx);
            this.latestConstraintIntroducingTxField = latestConstraintIntroducingTx;
        }
    }

    private void readAllFields(PageCursor cursor) throws IOException {
        do {
            this.creationTimeField = this.getRecordValue(cursor, Position.TIME);
            this.randomNumberField = this.getRecordValue(cursor, Position.RANDOM_NUMBER);
            this.versionField = this.getRecordValue(cursor, Position.LOG_VERSION);
            long lastCommittedTxId = this.getRecordValue(cursor, Position.LAST_TRANSACTION_ID);
            this.lastCommittingTxField.set(lastCommittedTxId);
            this.storeVersionField = this.getRecordValue(cursor, Position.STORE_VERSION);
            this.graphNextPropField = this.getRecordValue(cursor, Position.FIRST_GRAPH_PROPERTY);
            this.latestConstraintIntroducingTxField = this.getRecordValue(cursor, Position.LAST_CONSTRAINT_TRANSACTION);
            this.upgradeTxIdField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_ID);
            this.upgradeTxChecksumField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_CHECKSUM);
            this.upgradeTimeField = this.getRecordValue(cursor, Position.UPGRADE_TIME);
            long lastClosedTransactionLogVersion = this.getRecordValue(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
            long lastClosedTransactionLogByteOffset = this.getRecordValue(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
            this.lastClosedTx.set(lastCommittedTxId, new long[]{lastClosedTransactionLogVersion, lastClosedTransactionLogByteOffset});
            this.highestCommittedTransaction.set(lastCommittedTxId, this.getRecordValue(cursor, Position.LAST_TRANSACTION_CHECKSUM), this.getRecordValue(cursor, Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, 1L));
            this.upgradeCommitTimestampField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, 0L);
            this.upgradeTransaction = new TransactionId(this.upgradeTxIdField, this.upgradeTxChecksumField, this.upgradeCommitTimestampField);
        } while (cursor.shouldRetry());
        if (cursor.checkAndClearBoundsFlag()) {
            throw new UnderlyingStorageException("Out of page bounds when reading all meta-data fields. The page in question is page " + cursor.getCurrentPageId() + " of file " + this.storageFileName.getAbsolutePath() + ", which is " + cursor.getCurrentPageSize() + " bytes in size");
        }
    }

    long getRecordValue(PageCursor cursor, Position position) {
        return this.getRecordValue(cursor, position, -1L);
    }

    private long getRecordValue(PageCursor cursor, Position position, long defaultValue) {
        MetaDataRecord record = this.newRecord();
        try {
            record.setId(position.id);
            this.recordFormat.read(record, cursor, RecordLoad.FORCE, 9);
            if (record.inUse()) {
                return record.getValue();
            }
            return defaultValue;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void refreshFields() {
        this.scanAllFields(1, (Visitor<PageCursor, IOException>)((Visitor)element -> {
            this.readAllFields((PageCursor)element);
            return false;
        }));
    }

    private void scanAllFields(int pf_flags, Visitor<PageCursor, IOException> visitor) {
        try (PageCursor cursor = this.storeFile.io(0L, pf_flags);){
            if (cursor.next()) {
                visitor.visit((Object)cursor);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private void setRecord(Position position, long value) {
        long id = position.id;
        this.setHighestPossibleIdInUse(id);
        MetaDataRecord record = new MetaDataRecord();
        record.initialize(true, value);
        record.setId(id);
        this.updateRecord(record);
    }

    private void setRecord(PageCursor cursor, Position position, long value) throws IOException {
        if (!cursor.isWriteLocked()) {
            throw new IllegalArgumentException("Cannot write record without a page cursor that is write-locked");
        }
        int offset = this.offsetForId(position.id);
        cursor.setOffset(offset);
        cursor.putByte(Record.IN_USE.byteValue());
        cursor.putLong(value);
        this.checkForDecodingErrors(cursor, position.id, RecordLoad.NORMAL);
    }

    public NeoStoreRecord graphPropertyRecord() {
        NeoStoreRecord result = new NeoStoreRecord();
        result.setNextProp(this.getGraphNextProp());
        return result;
    }

    public static long versionStringToLong(String storeVersion) {
        if ("Unknown".equals(storeVersion)) {
            return -1L;
        }
        Bits bits = Bits.bits(8);
        int length = storeVersion.length();
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The given string %s is not of proper size for a store version string", storeVersion));
        }
        bits.put(length, 8);
        for (int i = 0; i < length; ++i) {
            char c = storeVersion.charAt(i);
            if (c >= '\u0100') {
                throw new IllegalArgumentException(String.format("Store version strings should be encode-able as Latin1 - %s is not", storeVersion));
            }
            bits.put(c, 8);
        }
        return bits.getLong();
    }

    public static String versionLongToString(long storeVersion) {
        if (storeVersion == -1L) {
            return "Unknown";
        }
        Bits bits = Bits.bitsFromLongs(new long[]{storeVersion});
        int length = bits.getShort(8);
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The read version string length %d is not proper.", length));
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    @Override
    public long nextCommittingTransactionId() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastCommittingTxField.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionCommitted(long transactionId, long checksum, long commitTimestamp) {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        if (this.highestCommittedTransaction.offer(transactionId, checksum, commitTimestamp)) {
            Object object = this.transactionCommittedLock;
            synchronized (object) {
                if (this.highestCommittedTransaction.get().transactionId() == transactionId) {
                    long pageId = this.pageIdForRecord(Position.LAST_TRANSACTION_ID.id);
                    assert (pageId == this.pageIdForRecord(Position.LAST_TRANSACTION_CHECKSUM.id));
                    try (PageCursor cursor = this.storeFile.io(pageId, 2);){
                        if (cursor.next()) {
                            this.setRecord(cursor, Position.LAST_TRANSACTION_ID, transactionId);
                            this.setRecord(cursor, Position.LAST_TRANSACTION_CHECKSUM, checksum);
                            this.setRecord(Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, commitTimestamp);
                        }
                    }
                    catch (IOException e) {
                        throw new UnderlyingStorageException(e);
                    }
                }
            }
        }
    }

    @Override
    public long getLastCommittedTransactionId() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.highestCommittedTransaction.get().transactionId();
    }

    @Override
    public TransactionId getLastCommittedTransaction() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.highestCommittedTransaction.get();
    }

    @Override
    public TransactionId getUpgradeTransaction() {
        this.assertNotClosed();
        this.checkInitialized(this.upgradeTxIdField);
        return this.upgradeTransaction;
    }

    @Override
    public long getLastClosedTransactionId() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastClosedTx.getHighestGapFreeNumber();
    }

    @Override
    public void awaitClosedTransactionId(long txId, long timeoutMillis) throws TimeoutException, InterruptedException {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        this.lastClosedTx.await(txId, timeoutMillis);
    }

    @Override
    public long[] getLastClosedTransaction() {
        this.assertNotClosed();
        this.checkInitialized(this.lastCommittingTxField.get());
        return this.lastClosedTx.get();
    }

    private void checkInitialized(long field) {
        if (field == Long.MIN_VALUE) {
            this.refreshFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionClosed(long transactionId, long logVersion, long byteOffset) {
        if (this.lastClosedTx.offer(transactionId, new long[]{logVersion, byteOffset})) {
            long pageId = this.pageIdForRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION.id);
            assert (pageId == this.pageIdForRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET.id));
            Object object = this.transactionClosedLock;
            synchronized (object) {
                try (PageCursor cursor = this.storeFile.io(pageId, 2);){
                    if (cursor.next()) {
                        long[] lastClosedTransactionData = this.lastClosedTx.get();
                        this.setRecord(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, lastClosedTransactionData[1]);
                        this.setRecord(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, lastClosedTransactionData[2]);
                    }
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException(e);
                }
            }
        }
    }

    @Override
    public boolean closedTransactionIdIsOnParWithOpenedTransactionId() {
        boolean onPar;
        boolean bl = onPar = this.lastClosedTx.getHighestGapFreeNumber() == this.lastCommittingTxField.get();
        if (!onPar) {
            this.transactionCloseWaitLogger.info(String.format("Waiting for all transactions to close...%n committed:  %s%n  committing: %s%n  closed:     %s", this.highestCommittedTransaction.get(), this.lastCommittingTxField, this.lastClosedTx));
        }
        return onPar;
    }

    public void logRecords(Logger msgLog) {
        this.scanAllFields(1, (Visitor<PageCursor, IOException>)((Visitor)cursor -> {
            for (Position position : Position.values()) {
                long value;
                do {
                    value = this.getRecordValue((PageCursor)cursor, position);
                } while (cursor.shouldRetry());
                boolean bounds = cursor.checkAndClearBoundsFlag();
                msgLog.log(position.name() + " (" + position.description() + "): " + value + (bounds ? " (out-of-bounds detected; value cannot be trusted)" : ""));
            }
            return false;
        }));
    }

    @Override
    public MetaDataRecord newRecord() {
        return new MetaDataRecord();
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, MetaDataRecord record) throws FAILURE {
        throw new UnsupportedOperationException();
    }

    @Override
    public void prepareForCommit(MetaDataRecord record) {
    }

    public static enum Position {
        TIME(0, "Creation time"),
        RANDOM_NUMBER(1, "Random number for store id"),
        LOG_VERSION(2, "Current log version"),
        LAST_TRANSACTION_ID(3, "Last committed transaction"),
        STORE_VERSION(4, "Store format version"),
        FIRST_GRAPH_PROPERTY(5, "First property record containing graph properties"),
        LAST_CONSTRAINT_TRANSACTION(6, "Last committed transaction containing constraint changes"),
        UPGRADE_TRANSACTION_ID(7, "Transaction id most recent upgrade was performed at"),
        UPGRADE_TIME(8, "Time of last upgrade"),
        LAST_TRANSACTION_CHECKSUM(9, "Checksum of last committed transaction"),
        UPGRADE_TRANSACTION_CHECKSUM(10, "Checksum of transaction id the most recent upgrade was performed at"),
        LAST_CLOSED_TRANSACTION_LOG_VERSION(11, "Log version where the last transaction commit entry has been written into"),
        LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET(12, "Byte offset in the log file where the last transaction commit entry has been written into"),
        LAST_TRANSACTION_COMMIT_TIMESTAMP(13, "Commit time timestamp for last committed transaction"),
        UPGRADE_TRANSACTION_COMMIT_TIMESTAMP(14, "Commit timestamp of transaction the most recent upgrade was performed at");

        private final int id;
        private final String description;

        private Position(int id, String description) {
            this.id = id;
            this.description = description;
        }

        public int id() {
            return this.id;
        }

        public String description() {
            return this.description;
        }
    }
}

