/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class DefaultPageCacheTracerTest {
    private PageCacheTracer tracer;
    private PageSwapper swapper;

    @Before
    public void setUp() {
        this.tracer = new DefaultPageCacheTracer();
        this.swapper = new DummyPageSwapper("filename");
    }

    @Test
    public void mustCountEvictions() {
        try (EvictionRunEvent evictionRunEvent = this.tracer.beginPageEvictions(2);){
            FlushEvent flushEvent;
            try (EvictionEvent evictionEvent = evictionRunEvent.beginEviction();){
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0, this.swapper);
                flushEvent.addBytesWritten(12L);
                flushEvent.done();
            }
            evictionEvent = evictionRunEvent.beginEviction();
            var4_6 = null;
            try {
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0, this.swapper);
                flushEvent.addBytesWritten(12L);
                flushEvent.done();
                evictionEvent.threwException(new IOException());
            }
            catch (Throwable flushEvent2) {
                var4_6 = flushEvent2;
                throw flushEvent2;
            }
            finally {
                if (evictionEvent != null) {
                    if (var4_6 != null) {
                        try {
                            evictionEvent.close();
                        }
                        catch (Throwable flushEvent2) {
                            var4_6.addSuppressed(flushEvent2);
                        }
                    } else {
                        evictionEvent.close();
                    }
                }
            }
            evictionEvent = evictionRunEvent.beginEviction();
            var4_6 = null;
            try {
                flushEvent = evictionEvent.flushEventOpportunity().beginFlush(0L, 0, this.swapper);
                flushEvent.addBytesWritten(12L);
                flushEvent.done();
                evictionEvent.threwException(new IOException());
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (evictionEvent != null) {
                    if (var4_6 != null) {
                        try {
                            evictionEvent.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        evictionEvent.close();
                    }
                }
            }
            evictionRunEvent.beginEviction().close();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 4L, 2L, 3L, 0L, 36L, 0L, 0L);
    }

    @Test
    public void mustCountFileMappingAndUnmapping() {
        this.tracer.mappedFile(new File("a"));
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L);
        this.tracer.unmappedFile(new File("a"));
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1L);
    }

    @Test
    public void mustCountFlushes() {
        try (MajorFlushEvent cacheFlush = this.tracer.beginCacheFlush();){
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
            cacheFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 3L, 0L, 0L, 0L, 0L);
        var2_2 = null;
        try (MajorFlushEvent fileFlush = this.tracer.beginFileFlush(this.swapper);){
            fileFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
            fileFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
            fileFlush.flushEventOpportunity().beginFlush(0L, 0, this.swapper).done();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        this.assertCounts(0L, 0L, 0L, 0L, 0L, 0L, 6L, 0L, 0L, 0L, 0L);
    }

    private void assertCounts(long pins, long unpins, long hits, long faults, long evictions, long evictionExceptions, long flushes, long bytesRead, long bytesWritten, long filesMapped, long filesUnmapped) {
        Assert.assertThat((String)"pins", (Object)this.tracer.pins(), (Matcher)Matchers.is((Object)pins));
        Assert.assertThat((String)"unpins", (Object)this.tracer.unpins(), (Matcher)Matchers.is((Object)unpins));
        Assert.assertThat((String)"hits", (Object)this.tracer.hits(), (Matcher)Matchers.is((Object)hits));
        Assert.assertThat((String)"faults", (Object)this.tracer.faults(), (Matcher)Matchers.is((Object)faults));
        Assert.assertThat((String)"evictions", (Object)this.tracer.evictions(), (Matcher)Matchers.is((Object)evictions));
        Assert.assertThat((String)"evictionExceptions", (Object)this.tracer.evictionExceptions(), (Matcher)Matchers.is((Object)evictionExceptions));
        Assert.assertThat((String)"flushes", (Object)this.tracer.flushes(), (Matcher)Matchers.is((Object)flushes));
        Assert.assertThat((String)"bytesRead", (Object)this.tracer.bytesRead(), (Matcher)Matchers.is((Object)bytesRead));
        Assert.assertThat((String)"bytesWritten", (Object)this.tracer.bytesWritten(), (Matcher)Matchers.is((Object)bytesWritten));
        Assert.assertThat((String)"filesMapped", (Object)this.tracer.filesMapped(), (Matcher)Matchers.is((Object)filesMapped));
        Assert.assertThat((String)"filesUnmapped", (Object)this.tracer.filesUnmapped(), (Matcher)Matchers.is((Object)filesUnmapped));
    }
}

