/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.status.play;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.nd4j.parameterserver.model.MasterStatus;
import org.nd4j.parameterserver.model.ServerTypeJson;
import org.nd4j.parameterserver.model.SlaveStatus;
import org.nd4j.parameterserver.model.SubscriberState;
import org.nd4j.parameterserver.status.play.StatusStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.routing.Router;
import play.libs.F;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;
import play.routing.RoutingDsl;
import play.server.Server;

public class StatusServer {
    private static final Logger log = LoggerFactory.getLogger(StatusServer.class);

    public static Server startServer(final StatusStorage statusStorage, int statusServerPort) {
        log.info("Starting server on port " + statusServerPort);
        RoutingDsl dsl = new RoutingDsl();
        dsl.GET("/ids/").routeTo((F.Function0)new F.Function0<Result>(){

            public Result apply() throws Throwable {
                List<Integer> ids = statusStorage.ids();
                return Results.ok((JsonNode)Json.toJson(ids));
            }
        });
        dsl.GET("/state/:id").routeTo((F.Function)new F.Function<String, Result>(){

            public Result apply(String id) throws Throwable {
                return Results.ok((JsonNode)Json.toJson((Object)statusStorage.getState(Integer.parseInt(id))));
            }
        });
        dsl.GET("/type/:id").routeTo((F.Function)new F.Function<String, Result>(){

            public Result apply(String id) throws Throwable {
                return Results.ok((JsonNode)Json.toJson((Object)ServerTypeJson.builder().type(statusStorage.getState(Integer.parseInt(id)).serverType())));
            }
        });
        dsl.GET("/started/:id").routeTo((F.Function)new F.Function<String, Result>(){

            public Result apply(String id) throws Throwable {
                return statusStorage.getState(Integer.parseInt(id)).isMaster() ? Results.ok((JsonNode)Json.toJson((Object)MasterStatus.builder().master(statusStorage.getState(Integer.parseInt(id)).getServerState()).responder(statusStorage.getState(Integer.parseInt(id) + 1).getServerState()).responderN(statusStorage.getState(Integer.parseInt(id)).getTotalUpdates()).build())) : Results.ok((JsonNode)Json.toJson((Object)SlaveStatus.builder().slave(statusStorage.getState(Integer.parseInt(id)).serverType()).build()));
            }
        });
        dsl.GET("/connectioninfo/:id").routeTo((F.Function)new F.Function<String, Result>(){

            public Result apply(String id) throws Throwable {
                return Results.ok((JsonNode)Json.toJson((Object)statusStorage.getState(Integer.parseInt(id)).getConnectionInfo()));
            }
        });
        dsl.POST("/updatestatus/:id").routeTo((F.Function)new F.Function<String, Result>(){

            public Result apply(String id) throws Throwable {
                SubscriberState subscriberState = (SubscriberState)Json.fromJson((JsonNode)Controller.request().body().asJson(), SubscriberState.class);
                statusStorage.updateState(subscriberState);
                return Results.ok((JsonNode)Json.toJson((Object)subscriberState));
            }
        });
        Server server = Server.forRouter((Router)dsl.build(), (int)statusServerPort);
        return server;
    }
}

