/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.status.play;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.nd4j.parameterserver.model.SubscriberState;
import org.nd4j.parameterserver.status.play.BaseStatusStorage;

public class MapDbStatusStorage
extends BaseStatusStorage {
    private DB db;
    private File storageFile;

    public MapDbStatusStorage(long heartBeatEjectionMilliSeconds, long checkInterval) {
        super(heartBeatEjectionMilliSeconds, checkInterval);
    }

    public MapDbStatusStorage() {
        this(1000L, 1000L);
    }

    @Override
    public Map<Integer, Long> createUpdatedMap() {
        this.db = this.storageFile == null ? DBMaker.memoryDB().make() : DBMaker.fileDB((File)this.storageFile).closeOnJvmShutdown().transactionEnable().make();
        this.updated = this.db.hashMap("updated").keySerializer((Serializer)Serializer.INTEGER).valueSerializer((Serializer)Serializer.LONG).createOrOpen();
        return this.updated;
    }

    @Override
    public Map<Integer, SubscriberState> createMap() {
        this.db = this.storageFile == null ? DBMaker.memoryDB().make() : DBMaker.fileDB((File)this.storageFile).closeOnJvmShutdown().transactionEnable().make();
        this.statusStorageMap = this.db.hashMap("statusStorageMap").keySerializer((Serializer)Serializer.INTEGER).valueSerializer((Serializer)new StatusStorageSerializer()).createOrOpen();
        return this.statusStorageMap;
    }

    @Override
    public SubscriberState getState(int id) {
        if (!this.statusStorageMap.containsKey(id)) {
            return SubscriberState.empty();
        }
        return (SubscriberState)this.statusStorageMap.get(id);
    }

    private class StatusStorageSerializer
    implements Serializer<SubscriberState> {
        private StatusStorageSerializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull SubscriberState value) throws IOException {
            value.write((DataOutput)out);
        }

        public SubscriberState deserialize(@NotNull DataInput2 input, int available) throws IOException {
            return SubscriberState.read((DataInput)input);
        }

        public int compare(SubscriberState p1, SubscriberState p2) {
            return p1.compareTo(p2);
        }
    }
}

