/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.status.play;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.nd4j.parameterserver.model.SubscriberState;
import org.nd4j.parameterserver.status.play.StatusStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStatusStorage
implements StatusStorage {
    private static final Logger log = LoggerFactory.getLogger(BaseStatusStorage.class);
    protected Map<Integer, SubscriberState> statusStorageMap = this.createMap();
    private ScheduledExecutorService executorService;
    protected Map<Integer, Long> updated;
    private long heartBeatEjectionMilliSeconds = 1000L;
    private long checkInterval = 1000L;

    public BaseStatusStorage() {
        this(1000L, 1000L);
    }

    @Override
    public List<Integer> ids() {
        return new ArrayList<Integer>(this.statusStorageMap.keySet());
    }

    @Override
    public int numStates() {
        return this.statusStorageMap.size();
    }

    public BaseStatusStorage(long heartBeatEjectionMilliSeconds, long checkInterval) {
        this.heartBeatEjectionMilliSeconds = heartBeatEjectionMilliSeconds;
        this.checkInterval = checkInterval;
        this.init();
    }

    private void init() {
        this.updated = this.createUpdatedMap();
        this.executorService = Executors.newScheduledThreadPool(1);
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long curr = System.currentTimeMillis();
                HashSet<Integer> remove = new HashSet<Integer>();
                for (Map.Entry<Integer, Long> entry : BaseStatusStorage.this.updated.entrySet()) {
                    long val = entry.getValue();
                    long diff = Math.abs(curr - val);
                    if (diff <= BaseStatusStorage.this.heartBeatEjectionMilliSeconds) continue;
                    remove.add(entry.getKey());
                }
                if (!remove.isEmpty()) {
                    log.info("Removing " + remove.size() + " entries");
                }
                for (Integer i : remove) {
                    BaseStatusStorage.this.updated.remove(i);
                    BaseStatusStorage.this.statusStorageMap.remove(i);
                }
            }
        }, 30000L, this.checkInterval, TimeUnit.MILLISECONDS);
    }

    public abstract Map<Integer, Long> createUpdatedMap();

    public abstract Map<Integer, SubscriberState> createMap();

    @Override
    public SubscriberState getState(int id) {
        if (!this.statusStorageMap.containsKey(id)) {
            return SubscriberState.empty();
        }
        return this.statusStorageMap.get(id);
    }

    @Override
    public void updateState(SubscriberState subscriberState) {
        this.updated.put(subscriberState.getStreamId(), System.currentTimeMillis());
        this.statusStorageMap.put(subscriberState.getStreamId(), subscriberState);
    }
}

