/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.modelmapper.internal.converter.IterableConverter;
import org.modelmapper.internal.typetools.TypeResolver;
import org.modelmapper.internal.util.Iterables;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MappingContext;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;

class CollectionConverter
extends IterableConverter<Object, Collection<Object>> {
    CollectionConverter() {
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Iterables.isIterable(sourceType) && Collection.class.isAssignableFrom(destinationType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    @Override
    protected Collection<Object> createDestination(MappingContext<Object, Collection<Object>> context, int length) {
        if (context.getDestinationType().isInterface()) {
            if (SortedSet.class.isAssignableFrom(context.getDestinationType())) {
                return new TreeSet<Object>();
            }
            if (Set.class.isAssignableFrom(context.getDestinationType())) {
                return new HashSet<Object>();
            }
            return new ArrayList<Object>(length);
        }
        return context.getMappingEngine().createDestination(context);
    }

    @Override
    protected Class<?> getElementType(MappingContext<Object, Collection<Object>> context) {
        Mapping mapping = context.getMapping();
        if (mapping instanceof PropertyMapping) {
            PropertyInfo destInfo = ((PropertyMapping)mapping).getLastDestinationProperty();
            Class<?> elementType = TypeResolver.resolveRawArgument(destInfo.getGenericType(), destInfo.getInitialType());
            return elementType == TypeResolver.Unknown.class ? Object.class : elementType;
        }
        if (context.getGenericDestinationType() instanceof ParameterizedType) {
            return Types.rawTypeFor(((ParameterizedType)context.getGenericDestinationType()).getActualTypeArguments()[0]);
        }
        return Object.class;
    }

    @Override
    protected void setElement(Collection<Object> destination, Object element, int index) {
        destination.add(element);
    }
}

