/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.modelmapper.Converter;
import org.modelmapper.ExpressionMap;
import org.modelmapper.PropertyMap;
import org.modelmapper.TypeMap;
import org.modelmapper.internal.ConfigurableMapExpressionImpl;
import org.modelmapper.internal.ImplicitMappingBuilder;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.MappingEngineImpl;
import org.modelmapper.internal.TypeMapImpl;
import org.modelmapper.internal.TypePair;
import org.modelmapper.internal.util.Primitives;
import org.modelmapper.internal.util.Types;

public final class TypeMapStore {
    private final Map<TypePair<?, ?>, TypeMap<?, ?>> typeMaps = new ConcurrentHashMap();
    private final Map<TypePair<?, ?>, TypeMap<?, ?>> immutableTypeMaps = Collections.unmodifiableMap(this.typeMaps);
    private final Object lock = new Object();
    private final InheritingConfiguration config;

    TypeMapStore(InheritingConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, D> TypeMap<S, D> create(S source, Class<S> sourceType, Class<D> destinationType, String typeMapName, InheritingConfiguration configuration, MappingEngineImpl engine) {
        Object object = this.lock;
        synchronized (object) {
            TypeMapImpl<S, D> typeMap = new TypeMapImpl<S, D>(sourceType, destinationType, typeMapName, configuration, engine);
            if (configuration.isImplicitMappingEnabled() && Types.mightContainsProperties(typeMap.getSourceType()) && Types.mightContainsProperties(typeMap.getDestinationType())) {
                new ImplicitMappingBuilder<S, D>(source, typeMap, this.config.typeMapStore, this.config.converterStore).build();
            }
            this.typeMaps.put(TypePair.of(sourceType, destinationType, typeMapName), typeMap);
            return typeMap;
        }
    }

    public Collection<TypeMap<?, ?>> get() {
        return this.immutableTypeMaps.values();
    }

    public <S, D> TypeMap<S, D> get(Class<S> sourceType, Class<D> destinationType, String typeMapName) {
        TypeMap<?, ?> typeMap = this.typeMaps.get(TypePair.of(sourceType, destinationType, typeMapName));
        if (typeMap != null) {
            return typeMap;
        }
        for (TypePair<?, ?> typePair : this.getPrimitiveWrapperTypePairs(sourceType, destinationType, typeMapName)) {
            typeMap = this.typeMaps.get(typePair);
            if (typeMap == null) continue;
            return typeMap;
        }
        return null;
    }

    public <S, D> TypeMap<S, D> getOrCreate(S source, Class<S> sourceType, Class<D> destinationType, String typeMapName, MappingEngineImpl engine) {
        return this.getOrCreate(source, sourceType, destinationType, typeMapName, null, null, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, D> TypeMap<S, D> getOrCreate(S source, Class<S> sourceType, Class<D> destinationType, String typeMapName, PropertyMap<S, D> propertyMap, Converter<S, D> converter, MappingEngineImpl engine) {
        Object object = this.lock;
        synchronized (object) {
            TypePair<S, D> typePair = TypePair.of(sourceType, destinationType, typeMapName);
            TypeMapImpl<S, D> typeMap = (TypeMapImpl<S, D>)this.typeMaps.get(typePair);
            if (typeMap == null) {
                typeMap = new TypeMapImpl<S, D>(sourceType, destinationType, typeMapName, this.config, engine);
                if (propertyMap != null) {
                    typeMap.addMappings(propertyMap);
                }
                if (converter == null && this.config.isImplicitMappingEnabled() && Types.mightContainsProperties(typeMap.getSourceType()) && Types.mightContainsProperties(typeMap.getDestinationType())) {
                    new ImplicitMappingBuilder<S, D>(source, typeMap, this.config.typeMapStore, this.config.converterStore).build();
                }
                if (typeMap.isFullMatching()) {
                    this.typeMaps.put(typePair, typeMap);
                }
            } else if (propertyMap != null) {
                typeMap.addMappings(propertyMap);
            }
            if (converter != null) {
                typeMap.setConverter(converter);
            }
            return typeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, D> TypeMap<S, D> getOrCreate(Class<S> sourceType, Class<D> destinationType, String typeMapName, ExpressionMap<S, D> mapper, MappingEngineImpl engine) {
        Object object = this.lock;
        synchronized (object) {
            TypePair<S, D> typePair = TypePair.of(sourceType, destinationType, typeMapName);
            TypeMapImpl<S, D> typeMap = (TypeMapImpl<S, D>)this.typeMaps.get(typePair);
            if (typeMap == null) {
                typeMap = new TypeMapImpl<S, D>(sourceType, destinationType, typeMapName, this.config, engine);
                this.typeMaps.put(typePair, typeMap);
            }
            mapper.configure(new ConfigurableMapExpressionImpl(typeMap));
            return typeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TypeMap<?, ?> typeMap) {
        TypePair<?, ?> typePair = TypePair.of(typeMap.getSourceType(), typeMap.getDestinationType(), typeMap.getName());
        Object object = this.lock;
        synchronized (object) {
            if (this.typeMaps.containsKey(typePair)) {
                throw new IllegalArgumentException("TypeMap exists in the store: " + typePair.toString());
            }
            this.typeMaps.put(typePair, typeMap);
        }
    }

    private <S, D> List<TypePair<?, ?>> getPrimitiveWrapperTypePairs(Class<S> sourceType, Class<D> destinationType, String typeMapName) {
        ArrayList typePairs = new ArrayList(1);
        if (Primitives.isPrimitive(sourceType)) {
            typePairs.add(TypePair.of(Primitives.wrapperFor(sourceType), destinationType, typeMapName));
        }
        if (Primitives.isPrimitive(destinationType)) {
            typePairs.add(TypePair.of(sourceType, Primitives.wrapperFor(destinationType), typeMapName));
        }
        if (Primitives.isPrimitive(sourceType) && Primitives.isPrimitiveWrapper(destinationType)) {
            typePairs.add(TypePair.of(Primitives.wrapperFor(sourceType), Primitives.wrapperFor(destinationType), typeMapName));
        }
        return typePairs;
    }
}

