/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import org.modelmapper.internal.BridgeClassLoaderFactory;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.bytebuddy.ByteBuddy;
import org.modelmapper.internal.bytebuddy.description.method.MethodDescription;
import org.modelmapper.internal.bytebuddy.implementation.InvocationHandlerAdapter;
import org.modelmapper.internal.bytebuddy.matcher.ElementMatcher;
import org.modelmapper.internal.bytebuddy.matcher.ElementMatchers;
import org.modelmapper.internal.objenesis.Objenesis;
import org.modelmapper.internal.objenesis.ObjenesisStd;
import org.modelmapper.internal.util.Primitives;

class ProxyFactory {
    private static final Objenesis OBJENESIS = new ObjenesisStd();
    private static final ElementMatcher<? super MethodDescription> METHOD_FILTER = ElementMatchers.not(ElementMatchers.named("toString").or(ElementMatchers.named("hashCode").or(ElementMatchers.named("equals"))));

    ProxyFactory() {
    }

    static <T> T proxyFor(Class<T> type, InvocationHandler interceptor, Errors errors) throws ErrorsException {
        return ProxyFactory.proxyFor(type, interceptor, errors, Boolean.FALSE);
    }

    static <T> T proxyFor(Class<T> type, InvocationHandler interceptor, Errors errors, boolean useOSGiClassLoaderBridging) throws ErrorsException {
        if (Primitives.isPrimitive(type)) {
            return Primitives.defaultValueForWrapper(type);
        }
        if (type.equals(String.class)) {
            return null;
        }
        if (Modifier.isFinal(type.getModifiers())) {
            throw errors.invocationAgainstFinalClass(type).toException();
        }
        try {
            return OBJENESIS.newInstance(new ByteBuddy().subclass(type).method(METHOD_FILTER).intercept(InvocationHandlerAdapter.of(interceptor)).make().load(useOSGiClassLoaderBridging ? BridgeClassLoaderFactory.getClassLoader(type) : type.getClassLoader()).getLoaded());
        }
        catch (Throwable t) {
            throw errors.errorInstantiatingProxy(type, t).toException();
        }
    }
}

