/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.modelmapper.config.Configuration;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.internal.PropertyInfoResolver;
import org.modelmapper.spi.NameTransformer;
import org.modelmapper.spi.NameableType;
import org.modelmapper.spi.NamingConvention;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyType;
import org.modelmapper.spi.ValueReader;

final class PropertyInfoSetResolver<T> {
    private PropertyInfoSetResolver() {
    }

    static boolean canAccessMember(Member member, Configuration.AccessLevel accessLevel) {
        int mod = member.getModifiers();
        switch (accessLevel) {
            default: {
                return Modifier.isPublic(mod);
            }
            case PROTECTED: {
                return Modifier.isPublic(mod) || Modifier.isProtected(mod);
            }
            case PACKAGE_PRIVATE: {
                return Modifier.isPublic(mod) || Modifier.isProtected(mod) || !Modifier.isPrivate(mod);
            }
            case PRIVATE: 
        }
        return true;
    }

    static <T> Map<String, Accessor> resolveAccessors(T source, Class<T> type, InheritingConfiguration configuration) {
        LinkedHashMap<String, Accessor> accessors = new LinkedHashMap<String, Accessor>();
        ValueReader<T> valueReader = null;
        if (source != null) {
            valueReader = configuration.valueAccessStore.getFirstSupportedReader(type);
        }
        if (valueReader == null) {
            PropertyInfoSetResolver.resolveProperties(type, true, configuration, accessors);
        } else {
            NameTransformer nameTransformer = configuration.getSourceNameTransformer();
            for (String memberName : valueReader.memberNames(source)) {
                ValueReader.Member<T> member = valueReader.getMember(source, memberName);
                if (member == null) continue;
                accessors.put(nameTransformer.transform(memberName, NameableType.GENERIC), PropertyInfoImpl.ValueReaderPropertyInfo.fromMember(member, memberName));
            }
        }
        return accessors;
    }

    static Map<String, Mutator> resolveMutators(Class<?> type, InheritingConfiguration configuration) {
        LinkedHashMap<String, Mutator> mutators = new LinkedHashMap<String, Mutator>();
        PropertyInfoSetResolver.resolveProperties(type, false, configuration, mutators);
        return mutators;
    }

    private static <M extends AccessibleObject, PI extends PropertyInfo> void resolveProperties(Class<?> type, boolean access, Configuration configuration, Map<String, PI> propertyInfo) {
        ResolveRequest resolveRequest = new ResolveRequest();
        resolveRequest.config = configuration;
        resolveRequest.propertyInfo = propertyInfo;
        if (access) {
            resolveRequest.namingConvention = configuration.getSourceNamingConvention();
            resolveRequest.nameTransformer = configuration.getSourceNameTransformer();
        } else {
            resolveRequest.namingConvention = configuration.getDestinationNamingConvention();
            resolveRequest.nameTransformer = configuration.getDestinationNameTransformer();
        }
        if (configuration.isFieldMatchingEnabled()) {
            resolveRequest.propertyType = PropertyType.FIELD;
            resolveRequest.accessLevel = configuration.getFieldAccessLevel();
            resolveRequest.propertyResolver = PropertyInfoResolver.FIELDS;
            PropertyInfoSetResolver.resolveProperties(type, type, resolveRequest);
        }
        resolveRequest.propertyType = PropertyType.METHOD;
        resolveRequest.accessLevel = configuration.getMethodAccessLevel();
        resolveRequest.propertyResolver = access ? PropertyInfoResolver.ACCESSORS : PropertyInfoResolver.MUTATORS;
        PropertyInfoSetResolver.resolveProperties(type, type, resolveRequest);
    }

    private static <M extends AccessibleObject, PI extends PropertyInfo> void resolveProperties(Class<?> initialType, Class<?> type, ResolveRequest<M, PI> resolveRequest) {
        Class<?> superType = type.getSuperclass();
        if (superType != null && superType != Object.class && superType != Enum.class) {
            PropertyInfoSetResolver.resolveProperties(initialType, superType, resolveRequest);
        }
        for (AccessibleObject member : (AccessibleObject[])resolveRequest.propertyResolver.membersFor(type)) {
            if (!PropertyInfoSetResolver.canAccessMember((Member)((Object)member), resolveRequest.accessLevel) || !resolveRequest.propertyResolver.isValid((Member)((Object)member)) || !resolveRequest.namingConvention.applies(((Member)((Object)member)).getName(), resolveRequest.propertyType)) continue;
            String name = resolveRequest.nameTransformer.transform(((Member)((Object)member)).getName(), PropertyType.FIELD.equals((Object)resolveRequest.propertyType) ? NameableType.FIELD : NameableType.METHOD);
            Object info = resolveRequest.propertyResolver.propertyInfoFor(initialType, (Member)((Object)member), resolveRequest.config, name);
            resolveRequest.propertyInfo.put(name, info);
            if (Modifier.isPublic(((Member)((Object)member)).getModifiers()) && Modifier.isPublic(((Member)((Object)member)).getDeclaringClass().getModifiers())) continue;
            try {
                member.setAccessible(true);
            }
            catch (SecurityException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static class ResolveRequest<M extends AccessibleObject, PI extends PropertyInfo> {
        Map<String, PI> propertyInfo;
        PropertyInfoResolver<M, PI> propertyResolver;
        PropertyType propertyType;
        Configuration config;
        Configuration.AccessLevel accessLevel;
        NamingConvention namingConvention;
        NameTransformer nameTransformer;

        private ResolveRequest() {
        }
    }
}

