/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.geo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.InputStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.geo.MfFeature;
import org.mapfish.geo.MfFeatureCollection;
import org.mapfish.geo.MfGeo;
import org.mapfish.geo.MfGeoFactory;
import org.mapfish.geo.MfGeometry;

public class MfGeoJSONReader {
    private final MfGeoFactory mfFactory;
    private final GeometryFactory jtsFactory;

    public MfGeoJSONReader(MfGeoFactory mfFactory) {
        this(mfFactory, new GeometryFactory());
    }

    public MfGeoJSONReader(MfGeoFactory mfFactory, GeometryFactory jtsFactory) {
        this.mfFactory = mfFactory;
        this.jtsFactory = jtsFactory;
    }

    public MfGeo decode(InputStream input) throws JSONException {
        JSONObject json = new JSONObject((Object)input);
        return this.decode(json);
    }

    public MfGeo decode(String input) throws JSONException {
        JSONObject json = new JSONObject(input);
        return this.decode(json);
    }

    public MfGeo decode(JSONObject json) throws JSONException {
        String type = json.getString("type");
        if (type.equals("FeatureCollection")) {
            return this.decodeFeatureCollection(json);
        }
        if (type.equals("Feature")) {
            return this.decodeFeature(json);
        }
        return this.decodeGeometry(json);
    }

    private MfFeatureCollection decodeFeatureCollection(JSONObject json) throws JSONException {
        JSONArray features = json.getJSONArray("features");
        ArrayList<MfFeature> collection = new ArrayList<MfFeature>(features.length());
        for (int cpt = 0; cpt < features.length(); ++cpt) {
            collection.add(this.decodeFeature(features.getJSONObject(cpt)));
        }
        return this.mfFactory.createFeatureCollection(collection);
    }

    private MfFeature decodeFeature(JSONObject json) throws JSONException {
        JSONObject geometry = json.optJSONObject("geometry");
        String id = json.optString("id", null);
        JSONObject properties = json.getJSONObject("properties");
        return this.mfFactory.createFeature(id, this.decodeGeometry(geometry), properties);
    }

    private MfGeometry decodeGeometry(JSONObject json) throws JSONException {
        return this.mfFactory.createGeometry(this.decodeJtsGeometry(json));
    }

    private Geometry decodeJtsGeometry(JSONObject json) throws JSONException {
        Point geometry;
        String type = json.getString("type");
        if (type.equals("GeometryCollection")) {
            JSONArray geoCoords = json.getJSONArray("geometries");
            Geometry[] geometries = new Geometry[geoCoords.length()];
            for (int i = 0; i < geometries.length; ++i) {
                geometries[i] = this.decodeJtsGeometry(geoCoords.getJSONObject(i));
            }
            geometry = this.jtsFactory.createGeometryCollection(geometries);
        } else {
            JSONArray coordinates = json.getJSONArray("coordinates");
            if (type.equals("Point")) {
                geometry = this.jtsFactory.createPoint(this.decodeCoordinate(coordinates));
            } else if (type.equals("LineString")) {
                geometry = this.jtsFactory.createLineString(this.decodeCoordinates(coordinates));
            } else if (type.equals("Polygon")) {
                geometry = this.decodePolygon(coordinates);
            } else if (type.equals("MultiPoint")) {
                Point[] points = new Point[coordinates.length()];
                for (int i = 0; i < points.length; ++i) {
                    points[i] = this.jtsFactory.createPoint(this.decodeCoordinate(coordinates.getJSONArray(i)));
                }
                geometry = this.jtsFactory.createMultiPoint(points);
            } else if (type.equals("MultiLineString")) {
                LineString[] lineStrings = new LineString[coordinates.length()];
                for (int i = 0; i < lineStrings.length; ++i) {
                    lineStrings[i] = this.jtsFactory.createLineString(this.decodeCoordinates(coordinates.getJSONArray(i)));
                }
                geometry = this.jtsFactory.createMultiLineString(lineStrings);
            } else if (type.equals("MultiPolygon")) {
                Polygon[] polygons = new Polygon[coordinates.length()];
                for (int i = 0; i < polygons.length; ++i) {
                    polygons[i] = this.decodePolygon(coordinates.getJSONArray(i));
                }
                geometry = this.jtsFactory.createMultiPolygon(polygons);
            } else {
                return null;
            }
        }
        return geometry;
    }

    private Polygon decodePolygon(JSONArray coordinates) throws JSONException {
        LinearRing outer = this.jtsFactory.createLinearRing(this.decodeCoordinates(coordinates.getJSONArray(0)));
        LinearRing[] holes = new LinearRing[coordinates.length() - 1];
        for (int i = 1; i < coordinates.length(); ++i) {
            holes[i - 1] = this.jtsFactory.createLinearRing(this.decodeCoordinates(coordinates.getJSONArray(i)));
        }
        return this.jtsFactory.createPolygon(outer, holes);
    }

    private Coordinate[] decodeCoordinates(JSONArray coordinates) throws JSONException {
        Coordinate[] result = new Coordinate[coordinates.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.decodeCoordinate(coordinates.getJSONArray(i));
        }
        return result;
    }

    private Coordinate decodeCoordinate(JSONArray coord) throws JSONException {
        if (coord.length() > 2) {
            return new Coordinate(coord.getDouble(0), coord.getDouble(1), coord.getDouble(2));
        }
        return new Coordinate(coord.getDouble(0), coord.getDouble(1));
    }
}

