/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.units;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;

public class Unit
implements Serializable {
    static final long serialVersionUID = -6704954923429734628L;
    public static final int ANGLE_UNIT = 0;
    public static final int LENGTH_UNIT = 1;
    public static final int AREA_UNIT = 2;
    public static final int VOLUME_UNIT = 3;
    public String name;
    public String plural;
    public String abbreviation;
    public double value;
    public static final NumberFormat format = NumberFormat.getNumberInstance();

    public Unit(String string, String string2, String string3, double d) {
        this.name = string;
        this.plural = string2;
        this.abbreviation = string3;
        this.value = d;
    }

    public double toBase(double d) {
        return d * this.value;
    }

    public double fromBase(double d) {
        return d / this.value;
    }

    public double parse(String string) throws NumberFormatException {
        try {
            return format.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage());
        }
    }

    public String format(double d) {
        return format.format(d) + " " + this.abbreviation;
    }

    public String format(double d, boolean bl) {
        if (bl) {
            return format.format(d) + " " + this.abbreviation;
        }
        return format.format(d);
    }

    public String format(double d, double d2, boolean bl) {
        if (bl) {
            return format.format(d) + "/" + format.format(d2) + " " + this.abbreviation;
        }
        return format.format(d) + "/" + format.format(d2);
    }

    public String format(double d, double d2) {
        return this.format(d, d2, true);
    }

    public String toString() {
        return this.plural;
    }

    public boolean equals(Object object) {
        if (object instanceof Unit) {
            return ((Unit)object).name.equals(this.name) && ((Unit)object).value == this.value;
        }
        return false;
    }

    static {
        format.setMaximumFractionDigits(2);
        format.setGroupingUsed(false);
    }
}

