/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.CylindricalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class TranverseCentralCylindricalProjection
extends CylindricalProjection {
    public TranverseCentralCylindricalProjection() {
        this.minLongitude = ProjectionMath.degToRad(-60.0);
        this.maxLongitude = ProjectionMath.degToRad(60.0);
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4 = Math.cos(d2) * Math.sin(d);
        double d5 = 1.0 - d4 * d4;
        if (d3 < 1.0E-10) {
            throw new ProjectionException("F");
        }
        projCoordinate.x = d4 / Math.sqrt(d5);
        projCoordinate.y = Math.atan2(Math.tan(d2), Math.cos(d));
        return projCoordinate;
    }

    @Override
    public boolean isRectilinear() {
        return false;
    }

    @Override
    public String toString() {
        return "Transverse Central Cylindrical";
    }
}

