/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.ConicProjection;
import org.osgeo.proj4j.util.ProjectionMath;

class SineTangentSeriesProjection
extends ConicProjection {
    private double C_x;
    private double C_y;
    private double C_p;
    private boolean tan_mode;

    protected SineTangentSeriesProjection(double d, double d2, boolean bl) {
        this.es = 0.0;
        this.C_x = d2 / d;
        this.C_y = d;
        this.C_p = 1.0 / d2;
        this.tan_mode = bl;
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = this.C_x * d * Math.cos(d2);
        projCoordinate.y = this.C_y;
        double d3 = Math.cos(d2 *= this.C_p);
        if (this.tan_mode) {
            projCoordinate.x *= d3 * d3;
            projCoordinate.y *= Math.tan(d2);
        } else {
            projCoordinate.x /= d3;
            projCoordinate.y *= Math.sin(d2);
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = this.tan_mode ? Math.atan(d2) : ProjectionMath.asin(d2 /= this.C_y);
        double d3 = Math.cos(projCoordinate.y);
        projCoordinate.y /= this.C_p;
        projCoordinate.x = d / (this.C_x * Math.cos(projCoordinate.y));
        projCoordinate.x = this.tan_mode ? (projCoordinate.x /= d3 * d3) : (projCoordinate.x *= d3);
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }
}

