/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class PolyconicProjection
extends Projection {
    private double ml0;
    private double[] en;
    private static final double TOL = 1.0E-10;
    private static final double CONV = 1.0E-10;
    private static final int N_ITER = 10;
    private static final int I_ITER = 20;
    private static final double ITOL = 1.0E-12;

    public PolyconicProjection() {
        this.minLatitude = ProjectionMath.degToRad(0.0);
        this.maxLatitude = ProjectionMath.degToRad(80.0);
        this.minLongitude = ProjectionMath.degToRad(-60.0);
        this.maxLongitude = ProjectionMath.degToRad(60.0);
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            if (Math.abs(d2) <= 1.0E-10) {
                projCoordinate.x = d;
                projCoordinate.y = this.ml0;
            } else {
                double d3 = 1.0 / Math.tan(d2);
                double d4 = d * Math.sin(d2);
                projCoordinate.x = Math.sin(d4) * d3;
                projCoordinate.y = d2 - this.projectionLatitude + d3 * (1.0 - Math.cos(d4));
            }
        } else if (Math.abs(d2) <= 1.0E-10) {
            projCoordinate.x = d;
            projCoordinate.y = -this.ml0;
        } else {
            double d5;
            double d6 = Math.sin(d2);
            double d7 = Math.cos(d2);
            double d8 = Math.abs(d5) > 1.0E-10 ? ProjectionMath.msfn(d6, d7, this.es) / d6 : 0.0;
            projCoordinate.x = d8 * Math.sin(projCoordinate.x *= d6);
            projCoordinate.y = ProjectionMath.mlfn(d2, d6, d7, this.en) - this.ml0 + d8 * (1.0 - Math.cos(d));
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3;
            double d4 = this.projectionLatitude + d2;
            if (Math.abs(d3) <= 1.0E-10) {
                projCoordinate.x = d;
                projCoordinate.y = 0.0;
            } else {
                double d5;
                d4 = d2;
                double d6 = d * d + d2 * d2;
                int n = 10;
                do {
                    double d7 = Math.tan(d4);
                    d5 = (d2 * (d4 * d7 + 1.0) - d4 - 0.5 * (d4 * d4 + d6) * d7) / ((d4 - d2) / d7 - 1.0);
                    d4 -= d5;
                } while (Math.abs(d5) > 1.0E-10 && --n > 0);
                if (n == 0) {
                    throw new ProjectionException("I");
                }
                projCoordinate.x = Math.asin(d * Math.tan(d4)) / Math.sin(d4);
                projCoordinate.y = d4;
            }
        } else if (Math.abs(d2 += this.ml0) <= 1.0E-10) {
            projCoordinate.x = d;
            projCoordinate.y = 0.0;
        } else {
            double d8;
            int n;
            double d9 = d2 * d2 + d * d;
            double d10 = d2;
            for (n = 20; n > 0; --n) {
                double d11 = Math.sin(d10);
                double d12 = Math.cos(d10);
                double d13 = d11 * d12;
                if (Math.abs(d12) < 1.0E-12) {
                    throw new ProjectionException("I");
                }
                double d14 = Math.sqrt(1.0 - this.es * d11 * d11);
                d8 = d11 * d14 / d12;
                double d15 = ProjectionMath.mlfn(d10, d11, d12, this.en);
                double d16 = d15 * d15 + d9;
                d14 = 1.0 / this.es / (d14 * d14 * d14);
                double d17 = (d15 + d15 + d8 * d16 - 2.0 * d2 * (d8 * d15 + 1.0)) / (this.es * d13 * (d16 - 2.0 * d2 * d15) / d8 + 2.0 * (d2 - d15) * (d8 * d14 - 1.0 / d13) - d14 - d14);
                d10 += d17;
                if (Math.abs(d17) <= 1.0E-12) break;
            }
            if (n == 0) {
                throw new ProjectionException("I");
            }
            d8 = Math.sin(d10);
            projCoordinate.x = Math.asin(d * Math.tan(d10) * Math.sqrt(1.0 - this.es * d8 * d8)) / Math.sin(d10);
            projCoordinate.y = d10;
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.spherical = true;
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            if (this.en == null) {
                throw new ProjectionException("E");
            }
            this.ml0 = ProjectionMath.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
        } else {
            this.ml0 = -this.projectionLatitude;
        }
    }

    @Override
    public String toString() {
        return "Polyconic (American)";
    }
}

