/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.Complex;
import org.osgeo.proj4j.util.ProjectionMath;

public class NewZealandMapGridProjection
extends Projection {
    private static final Complex[] bf = new Complex[]{new Complex(0.7557853228, 0.0), new Complex(0.249204646, 0.003371507), new Complex(-0.001541739, 0.04105856), new Complex(-0.10162907, 0.01727609), new Complex(-0.26623489, -0.36249218), new Complex(-0.6870983, -1.1651967)};
    private static final double[] tphi = new double[]{1.5627014243, 0.5185406398, -0.03333098, -0.1052906, -0.0368594, 0.007317, 0.0122, 0.00394, -0.0013};
    private static final double[] tpsi = new double[]{0.6399175073, -0.1358797613, 0.063294409, -0.02526853, 0.0117879, -0.0055161, 0.0026906, -0.001333, 6.7E-4, -3.4E-4};
    private static final double SECS_TO_RAD = 4.84813681109536E-6;
    private static final double RAD_TO_SECS = 206264.80624709636;

    public NewZealandMapGridProjection() {
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        Complex complex = new Complex(0.0, 0.0);
        d2 = (d2 - this.projectionLatitude) * 206264.80624709636;
        for (int i = tpsi.length - 1; i >= 0; --i) {
            complex.r = tpsi[i] + d2 * complex.r;
        }
        complex.r *= d2;
        complex.i = d;
        ProjectionMath.zpoly1(complex, bf);
        projCoordinate.x = complex.i;
        projCoordinate.y = complex.r;
        return projCoordinate;
    }

    @Override
    protected ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        Complex complex = new Complex(d2, d);
        Complex complex2 = new Complex(0.0, 0.0);
        Complex complex3 = new Complex(0.0, 0.0);
        for (n = 20; n > 0; --n) {
            Complex complex4 = ProjectionMath.zpoly1d(complex, bf, complex2);
            complex4.r -= d2;
            complex4.i -= d;
            double d3 = complex2.r * complex2.r + complex2.i * complex2.i;
            complex3.r = -(complex4.r * complex2.r + complex4.i * complex2.i) / d3;
            complex.r += complex3.r;
            complex3.i = -(complex4.i * complex2.r - complex4.r * complex2.i) / d3;
            complex.i += complex3.i;
            if (Math.abs(complex3.r) + Math.abs(complex3.i) <= 1.0E-10) break;
        }
        if (n > 0) {
            projCoordinate.x = complex.i;
            projCoordinate.y = tphi[tphi.length - 1];
            for (int i = tphi.length - 1; i > 0; --i) {
                projCoordinate.y = tphi[i] + complex.r * projCoordinate.y;
            }
            projCoordinate.y = this.projectionLongitude + complex.r * projCoordinate.x * 4.84813681109536E-6;
        } else {
            projCoordinate.x = Double.NaN;
            projCoordinate.y = Double.NaN;
        }
        return projCoordinate;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.a = 6378388.0;
        this.projectionLongitude = 3.01941960595019;
        this.projectionLatitude = -0.7155849933176751;
        this.falseEasting = 2510000.0;
        this.falseNorthing = 6023150.0;
    }

    @Override
    public String toString() {
        return "New Zealand Map Grid";
    }
}

