/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class NellProjection
extends Projection {
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = 2.0 * Math.sin(d2);
        double d4 = d2 * d2;
        projCoordinate.y *= 1.00371 + d4 * (-0.0935382 + d4 * -0.011412);
        for (int i = 10; i > 0; --i) {
            d4 = (d2 + Math.sin(d2) - d3) / (1.0 + Math.cos(d2));
            projCoordinate.y -= d4;
            if (Math.abs(d4) < 1.0E-7) break;
        }
        projCoordinate.x = 0.5 * d * (1.0 + Math.cos(d2));
        projCoordinate.y = d2;
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = 2.0 * d / (1.0 + Math.cos(d2));
        projCoordinate.y = ProjectionMath.asin(0.5 * (d2 + Math.sin(d2)));
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Nell";
    }
}

