/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;

public class McBrydeThomasFlatPolarQuarticProjection
extends PseudoCylindricalProjection {
    private static final int NITER = 20;
    private static final double EPS = 1.0E-7;
    private static final double ONETOL = 1.000001;
    private static final double C = 1.7071067811865475;
    private static final double RC = 0.585786437626905;
    private static final double FYC = 1.874758284622695;
    private static final double RYC = 0.533402096794177;
    private static final double FXC = 0.3124597141037825;
    private static final double RXC = 3.2004125807650623;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = 1.7071067811865475 * Math.sin(d2);
        for (int i = 20; i > 0; --i) {
            double d4 = (Math.sin(0.5 * d2) + Math.sin(d2) - d3) / (0.5 * Math.cos(0.5 * d2) + Math.cos(d2));
            projCoordinate.y -= d4;
            if (Math.abs(d4) < 1.0E-7) break;
        }
        projCoordinate.x = 0.3124597141037825 * d * (1.0 + 2.0 * Math.cos(d2) / Math.cos(0.5 * d2));
        projCoordinate.y = 1.874758284622695 * Math.sin(0.5 * d2);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = 0.0;
        double d4 = 0.533402096794177 * d2;
        if (Math.abs(d4) > 1.0) {
            if (Math.abs(d4) > 1.000001) {
                throw new ProjectionException("I");
            }
            if (d4 < 0.0) {
                d3 = -1.0;
                d4 = -Math.PI;
            } else {
                d3 = 1.0;
                d4 = Math.PI;
            }
        } else {
            d3 = d4;
            d4 = 2.0 * Math.asin(d3);
        }
        projCoordinate.x = 3.2004125807650623 * d / (1.0 + 2.0 * Math.cos(d4) / Math.cos(0.5 * d4));
        d4 = 0.585786437626905 * (d3 + Math.sin(d4));
        if (Math.abs(d4) > 1.0) {
            if (Math.abs(d4) > 1.000001) {
                throw new ProjectionException("I");
            }
            d4 = d4 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            d4 = Math.asin(d4);
        }
        projCoordinate.y = d4;
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public String toString() {
        return "McBryde-Thomas Flat-Polar Quartic";
    }
}

