/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class LambertAzimuthalEqualAreaProjection
extends Projection {
    private static final int N_POLE = 0;
    private static final int S_POLE = 1;
    private static final int EQUIT = 2;
    private static final int OBLIQ = 3;
    private int mode = 0;
    private double phi0;
    private double sinb1;
    private double cosb1;
    private double xmf;
    private double ymf;
    private double mmf;
    private double qp;
    private double dd;
    private double rq;
    private double[] apa;
    private double sinph0;
    private double cosph0;

    public LambertAzimuthalEqualAreaProjection() {
        this(false);
    }

    public LambertAzimuthalEqualAreaProjection(boolean bl) {
    }

    @Override
    public void initialize() {
        double d;
        super.initialize();
        this.phi0 = this.projectionLatitude;
        double d2 = Math.abs(this.phi0);
        this.mode = Math.abs(d - 1.5707963267948966) < 1.0E-10 ? (this.phi0 < 0.0 ? 1 : 0) : (Math.abs(d2) < 1.0E-10 ? 2 : 3);
        if (!this.spherical) {
            this.e = Math.sqrt(this.es);
            this.qp = ProjectionMath.qsfn(1.0, this.e, this.one_es);
            this.mmf = 0.5 / (1.0 - this.es);
            this.apa = ProjectionMath.authset(this.es);
            switch (this.mode) {
                case 0: 
                case 1: {
                    this.dd = 1.0;
                    break;
                }
                case 2: {
                    this.rq = Math.sqrt(0.5 * this.qp);
                    this.dd = 1.0 / this.rq;
                    this.xmf = 1.0;
                    this.ymf = 0.5 * this.qp;
                    break;
                }
                case 3: {
                    this.rq = Math.sqrt(0.5 * this.qp);
                    double d3 = Math.sin(this.phi0);
                    this.sinb1 = ProjectionMath.qsfn(d3, this.e, this.one_es) / this.qp;
                    this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
                    this.dd = Math.cos(this.phi0) / (Math.sqrt(1.0 - this.es * d3 * d3) * this.rq * this.cosb1);
                    this.xmf = this.rq;
                    this.ymf = this.xmf / this.dd;
                    this.xmf *= this.dd;
                }
            }
        } else if (this.mode == 3) {
            this.sinph0 = Math.sin(this.phi0);
            this.cosph0 = Math.cos(this.phi0);
        }
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            this.project_s(d, d2, projCoordinate);
        } else {
            this.project_e(d, d2, projCoordinate);
        }
        return projCoordinate;
    }

    public void project_s(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = Math.cos(d);
        switch (this.mode) {
            case 2: 
            case 3: {
                projCoordinate.y = this.mode == 2 ? 1.0 + d4 * d5 : 1.0 + this.sinph0 * d3 + this.cosph0 * d4 * d5;
                if (projCoordinate.y <= 1.0E-10) {
                    throw new ProjectionException("F");
                }
                projCoordinate.y = Math.sqrt(2.0 / projCoordinate.y);
                projCoordinate.x = projCoordinate.y * d4 * Math.sin(d);
                projCoordinate.y = projCoordinate.y * (this.mode == 2 ? d3 : this.cosph0 * d3 - this.sinph0 * d4 * d5);
                break;
            }
            case 0: {
                d5 = -d5;
            }
            case 1: {
                if (Math.abs(d2 + this.phi0) < 1.0E-10) {
                    throw new ProjectionException("F");
                }
                projCoordinate.y = 0.7853981633974483 - d2 * 0.5;
                projCoordinate.y = 2.0 * (this.mode == 1 ? Math.cos(projCoordinate.y) : Math.sin(projCoordinate.y));
                projCoordinate.x = projCoordinate.y * Math.sin(d);
                projCoordinate.y *= d5;
            }
        }
    }

    public void project_e(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = Math.sin(d2);
        double d9 = ProjectionMath.qsfn(d8, this.e, this.one_es);
        if (this.mode == 3 || this.mode == 2) {
            d3 = d9 / this.qp;
            d4 = Math.sqrt(1.0 - d3 * d3);
        }
        switch (this.mode) {
            case 3: {
                d5 = 1.0 + this.sinb1 * d3 + this.cosb1 * d4 * d6;
                break;
            }
            case 2: {
                d5 = 1.0 + d4 * d6;
                break;
            }
            case 0: {
                d5 = 1.5707963267948966 + d2;
                d9 = this.qp - d9;
                break;
            }
            case 1: {
                d5 = d2 - 1.5707963267948966;
                d9 = this.qp + d9;
            }
        }
        if (Math.abs(d5) < 1.0E-10) {
            throw new ProjectionException("F");
        }
        switch (this.mode) {
            case 2: 
            case 3: {
                if (this.mode == 3) {
                    d5 = Math.sqrt(2.0 / d5);
                    projCoordinate.y = this.ymf * d5 * (this.cosb1 * d3 - this.sinb1 * d4 * d6);
                } else {
                    d5 = Math.sqrt(2.0 / (1.0 + d4 * d6));
                    projCoordinate.y = d5 * d3 * this.ymf;
                }
                projCoordinate.x = this.xmf * d5 * d4 * d7;
                break;
            }
            case 0: 
            case 1: {
                if (d9 >= 0.0) {
                    d5 = Math.sqrt(d9);
                    projCoordinate.x = d5 * d7;
                    projCoordinate.y = d6 * (this.mode == 1 ? d5 : -d5);
                    break;
                }
                projCoordinate.y = 0.0;
                projCoordinate.x = 0.0;
            }
        }
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            this.projectInverse_s(d, d2, projCoordinate);
        } else {
            this.projectInverse_e(d, d2, projCoordinate);
        }
        return projCoordinate;
    }

    public void projectInverse_s(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = Math.hypot(d, d2);
        double d8 = d7 * 0.5;
        if (d4 > 1.0) {
            throw new ProjectionException("I_ERROR");
        }
        d8 = 2.0 * Math.asin(d8);
        if (this.mode == 3 || this.mode == 2) {
            d6 = Math.sin(d8);
            d5 = Math.cos(d8);
        }
        switch (this.mode) {
            case 2: {
                d8 = Math.abs(d7) <= 1.0E-10 ? 0.0 : Math.asin(d2 * d6 / d7);
                d *= d6;
                d2 = d5 * d7;
                break;
            }
            case 3: {
                d8 = Math.abs(d7) <= 1.0E-10 ? this.phi0 : Math.asin(d5 * this.sinph0 + d2 * d6 * this.cosph0 / d7);
                d *= d6 * this.cosph0;
                d2 = (d5 - Math.sin(d8) * this.sinph0) * d7;
                break;
            }
            case 0: {
                d2 = -d2;
                d8 = 1.5707963267948966 - d8;
                break;
            }
            case 1: {
                d8 -= 1.5707963267948966;
            }
        }
        projCoordinate.x = d3 = d2 == 0.0 && (this.mode == 2 || this.mode == 3) ? 0.0 : Math.atan2(d, d2);
        projCoordinate.y = d8;
    }

    public void projectInverse_e(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = 0.0;
        switch (this.mode) {
            case 2: 
            case 3: {
                double d4;
                double d5 = Math.hypot(d /= this.dd, d2 *= this.dd);
                if (d4 < 1.0E-10) {
                    double d6 = 0.0;
                    double d7 = this.phi0;
                    projCoordinate.x = d6;
                    projCoordinate.y = d7;
                    return;
                }
                double d8 = 2.0 * Math.asin(0.5 * d5 / this.rq);
                double d9 = Math.cos(d8);
                d8 = Math.sin(d8);
                d *= d8;
                if (this.mode == 3) {
                    d3 = d9 * this.sinb1 + d2 * d8 * this.cosb1 / d5;
                    double d10 = this.qp * d3;
                    d2 = d5 * this.cosb1 * d9 - d2 * this.sinb1 * d8;
                    break;
                }
                d3 = d2 * d8 / d5;
                double d11 = this.qp * d3;
                d2 = d5 * d9;
                break;
            }
            case 0: {
                d2 = -d2;
            }
            case 1: {
                double d12 = d * d + d2 * d2;
                if (0.0 == d12) {
                    double d13 = 0.0;
                    double d14 = this.phi0;
                    projCoordinate.x = d13;
                    projCoordinate.y = d14;
                    return;
                }
                d3 = 1.0 - d12 / this.qp;
                if (this.mode != 1) break;
                d3 = -d3;
            }
        }
        double d15 = Math.atan2(d, d2);
        double d16 = ProjectionMath.authlat(Math.asin(d3), this.apa);
        projCoordinate.x = d15;
        projCoordinate.y = d16;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Lambert Azimuthal Equal Area";
    }
}

