/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class HatanoProjection
extends Projection {
    private static final int NITER = 20;
    private static final double EPS = 1.0E-7;
    private static final double ONETOL = 1.000001;
    private static final double CN = 2.67595;
    private static final double CS = 2.43763;
    private static final double RCN = 0.3736990601468637;
    private static final double RCS = 0.4102345310814193;
    private static final double FYCN = 1.75859;
    private static final double FYCS = 1.93052;
    private static final double RYCN = 0.5686373742600607;
    private static final double RYCS = 0.5179951515653813;
    private static final double FXC = 0.85;
    private static final double RXC = 1.1764705882352942;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.sin(d2) * (d2 < 0.0 ? 2.43763 : 2.67595);
        for (int i = 20; i > 0; --i) {
            double d4 = (d2 + Math.sin(d2) - d3) / (1.0 + Math.cos(d2));
            d2 -= d4;
            if (Math.abs(d4) < 1.0E-7) break;
        }
        projCoordinate.x = 0.85 * d * Math.cos(d2 *= 0.5);
        projCoordinate.y = Math.sin(d2) * (d2 < 0.0 ? 1.93052 : 1.75859);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = d2 * (d2 < 0.0 ? 0.5179951515653813 : 0.5686373742600607);
        if (Math.abs(d3) > 1.0) {
            if (Math.abs(d3) > 1.000001) {
                throw new ProjectionException("I");
            }
            d3 = d3 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            d3 = Math.asin(d3);
        }
        projCoordinate.x = 1.1764705882352942 * d / Math.cos(d3);
        d3 += d3;
        projCoordinate.y = (d3 + Math.sin(d3)) * (d2 < 0.0 ? 0.4102345310814193 : 0.3736990601468637);
        if (Math.abs(projCoordinate.y) > 1.0) {
            if (Math.abs(projCoordinate.y) > 1.000001) {
                throw new ProjectionException("I");
            }
            projCoordinate.y = projCoordinate.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            projCoordinate.y = Math.asin(projCoordinate.y);
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Hatano Asymmetrical Equal Area";
    }
}

