/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class FoucautSinusoidalProjection
extends Projection {
    private double n;
    private double n1;
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.cos(d2);
        projCoordinate.x = d * d3 / (this.n + this.n1 * d3);
        projCoordinate.y = this.n * d2 + this.n1 * Math.sin(d2);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        if (this.n != 0.0) {
            int n;
            projCoordinate.y = d2;
            for (n = 10; n > 0; --n) {
                d3 = (this.n * projCoordinate.y + this.n1 * Math.sin(projCoordinate.y) - d2) / (this.n + this.n1 * Math.cos(projCoordinate.y));
                projCoordinate.y -= d3;
                if (Math.abs(d3) < 1.0E-7) break;
            }
            if (n == 0) {
                projCoordinate.y = d2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            }
        } else {
            projCoordinate.y = ProjectionMath.asin(d2);
        }
        d3 = Math.cos(projCoordinate.y);
        projCoordinate.x = d * (this.n + this.n1 * d3) / d3;
        return projCoordinate;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.n < 0.0 || this.n > 1.0) {
            throw new ProjectionException("-99");
        }
        this.n1 = 1.0 - this.n;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Foucaut Sinusoidal";
    }
}

