/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class EqualAreaCylindricalProjection
extends Projection {
    double[] apa;
    double qp;

    public EqualAreaCylindricalProjection() {
        this.minLatitude = Math.toRadians(-60.0);
        this.maxLatitude = Math.toRadians(60.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.es != 0.0) {
            projCoordinate.x = this.scaleFactor * d;
            projCoordinate.y = 0.5 * ProjectionMath.qsfn(Math.sin(d2), this.e, this.one_es) / this.scaleFactor;
        } else {
            projCoordinate.x = this.scaleFactor * d;
            projCoordinate.y = Math.sin(d2) / this.scaleFactor;
        }
        return projCoordinate;
    }

    @Override
    protected ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.es != 0.0) {
            projCoordinate.x = ProjectionMath.authlat(Math.asin(2.0 * d2 * this.scaleFactor / this.qp), this.apa);
            projCoordinate.y = d / this.scaleFactor;
        } else {
            double d3;
            double d4 = Math.abs(d2 *= this.scaleFactor);
            if (d3 - 1.0E-10 <= 1.0) {
                projCoordinate.x = d4 >= 1.0 ? (d2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(d2);
                projCoordinate.y = d / this.scaleFactor;
            } else {
                throw new ProjectionException();
            }
        }
        return projCoordinate;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.es != 0.0) {
            this.apa = ProjectionMath.authset(this.es);
            this.qp = ProjectionMath.qsfn(1.0, this.e, this.one_es);
        }
    }

    @Override
    public String toString() {
        return "Equal Area Cylindrical";
    }
}

