/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;

public class Eckert6Projection
extends PseudoCylindricalProjection {
    private static final double n = 2.5707963267948966;
    private static final double C_y = Math.sqrt(0.7779690592966855);
    private static final double C_x = C_y / 2.0;
    private static final int MAX_ITER = 8;
    private static final double LOOP_TOL = 1.0E-7;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        double d3 = 2.5707963267948966 * Math.sin(d2);
        for (n = 8; n > 0; --n) {
            double d4 = (d2 + Math.sin(d2) - d3) / (1.0 + Math.cos(d2));
            d2 -= d4;
            if (Math.abs(d4) < 1.0E-7) break;
        }
        if (n == 0) {
            throw new ProjectionException("F_ERROR");
        }
        projCoordinate.x = C_x * d * (1.0 + Math.cos(d2));
        projCoordinate.y = C_y * d2;
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = Math.asin(((d2 /= C_y) + Math.sin(d2)) / 2.5707963267948966);
        projCoordinate.x = d / (C_x * (1.0 + Math.cos(d2)));
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public String toString() {
        return "Eckert VI";
    }
}

