/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class Eckert4Projection
extends Projection {
    private static final double C_x = 0.4222382003157712;
    private static final double C_y = 1.3265004281770023;
    private static final double RC_y = 0.7538633073600218;
    private static final double C_p = 3.5707963267948966;
    private static final double RC_p = 0.2800495767557787;
    private static final double EPS = 1.0E-7;
    private final int NITER = 6;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        double d3 = 3.5707963267948966 * Math.sin(d2);
        double d4 = d2 * d2;
        d2 *= 0.895168 + d4 * (0.0218849 + d4 * 0.00826809);
        for (n = 6; n > 0; --n) {
            double d5 = Math.cos(d2);
            double d6 = Math.sin(d2);
            d4 = (d2 + d6 * (d5 + 2.0) - d3) / (1.0 + d5 * (d5 + 2.0) - d6 * d6);
            d2 -= d4;
            if (Math.abs(d4) < 1.0E-7) break;
        }
        if (n == 0) {
            projCoordinate.x = 0.4222382003157712 * d;
            projCoordinate.y = d2 < 0.0 ? -1.3265004281770023 : 1.3265004281770023;
        } else {
            projCoordinate.x = 0.4222382003157712 * d * (1.0 + Math.cos(d2));
            projCoordinate.y = 1.3265004281770023 * Math.sin(d2);
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = ProjectionMath.asin(d2 / 1.3265004281770023);
        double d3 = Math.cos(projCoordinate.y);
        projCoordinate.x = d / (0.4222382003157712 * (1.0 + d3));
        projCoordinate.y = ProjectionMath.asin((projCoordinate.y + Math.sin(projCoordinate.y) * (d3 + 2.0)) / 3.5707963267948966);
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public String toString() {
        return "Eckert IV";
    }
}

