/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class Eckert2Projection
extends Projection {
    private static final double FXC = 0.46065886596178063;
    private static final double FYC = 1.4472025091165353;
    private static final double C13 = 0.3333333333333333;
    private static final double ONEEPS = 1.0000001;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = Math.sqrt(4.0 - 3.0 * Math.sin(Math.abs(d2)));
        projCoordinate.x = 0.46065886596178063 * d * projCoordinate.y;
        projCoordinate.y = 1.4472025091165353 * (2.0 - projCoordinate.y);
        if (d2 < 0.0) {
            projCoordinate.y = -projCoordinate.y;
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = 2.0 - Math.abs(d2) / 1.4472025091165353;
        projCoordinate.x = d / (0.46065886596178063 * projCoordinate.y);
        projCoordinate.y = (4.0 - projCoordinate.y * projCoordinate.y) * 0.3333333333333333;
        if (Math.abs(projCoordinate.y) >= 1.0) {
            if (Math.abs(projCoordinate.y) > 1.0000001) {
                throw new ProjectionException("I");
            }
            projCoordinate.y = projCoordinate.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            projCoordinate.y = Math.asin(projCoordinate.y);
        }
        if (d2 < 0.0) {
            projCoordinate.y = -projCoordinate.y;
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Eckert II";
    }
}

