/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class CrasterProjection
extends Projection {
    private static final double XM = 0.9772050238058398;
    private static final double RXM = 1.0233267079464885;
    private static final double YM = 3.0699801238394655;
    private static final double RYM = 0.32573500793527993;
    private static final double THIRD = 0.3333333333333333;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = 0.9772050238058398 * d * (2.0 * Math.cos((d2 *= 0.3333333333333333) + d2) - 1.0);
        projCoordinate.y = 3.0699801238394655 * Math.sin(d2);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = 3.0 * Math.asin(d2 * 0.32573500793527993);
        projCoordinate.x = d * 1.0233267079464885 / (2.0 * Math.cos((projCoordinate.y + projCoordinate.y) * 0.3333333333333333) - 1.0);
        return projCoordinate;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Craster Parabolic (Putnins P4)";
    }
}

