/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.datum;

import java.io.Serializable;
import org.osgeo.proj4j.ProjCoordinate;

public final class PrimeMeridian
implements Serializable {
    private final String name;
    private final double offsetFromGreenwich;
    private static PrimeMeridian GREENWICH = new PrimeMeridian("greenwich", 0.0);
    private static PrimeMeridian[] wellKnownMeridians = new PrimeMeridian[]{PrimeMeridian.east("greenwich", 0.0, 0.0, 0.0), PrimeMeridian.west("lisbon", 9.0, 7.0, 54.862), PrimeMeridian.east("paris", 2.0, 20.0, 14.025), PrimeMeridian.west("bogota", 74.0, 4.0, 51.3), PrimeMeridian.west("madrid", 3.0, 41.0, 16.58), PrimeMeridian.east("rome", 12.0, 27.0, 8.4), PrimeMeridian.east("bern", 7.0, 26.0, 22.5), PrimeMeridian.east("jakarta", 106.0, 48.0, 27.79), PrimeMeridian.west("ferro", 17.0, 40.0, 0.0), PrimeMeridian.east("brussels", 4.0, 22.0, 4.71), PrimeMeridian.east("stockholm", 18.0, 3.0, 29.8), PrimeMeridian.east("athens", 23.0, 42.0, 58.815), PrimeMeridian.east("oslo", 10.0, 43.0, 22.5)};

    private static PrimeMeridian east(String string, double d, double d2, double d3) {
        double d4 = ((d3 / 60.0 + d2) / 60.0 + d) * (Math.PI / 180);
        return new PrimeMeridian(string, d4);
    }

    private static PrimeMeridian west(String string, double d, double d2, double d3) {
        return PrimeMeridian.east(string, -d, -d2, -d3);
    }

    public static PrimeMeridian forName(String string) {
        for (PrimeMeridian primeMeridian : wellKnownMeridians) {
            if (!primeMeridian.getName().equals(string)) continue;
            return primeMeridian;
        }
        try {
            return new PrimeMeridian("user-provided", Double.valueOf(string) * (Math.PI / 180));
        }
        catch (NumberFormatException numberFormatException) {
            return GREENWICH;
        }
    }

    private PrimeMeridian(String string, double d) {
        this.name = string;
        this.offsetFromGreenwich = d;
    }

    public String getName() {
        return this.name;
    }

    public void toGreenwich(ProjCoordinate projCoordinate) {
        projCoordinate.x += this.offsetFromGreenwich;
    }

    public void fromGreenwich(ProjCoordinate projCoordinate) {
        projCoordinate.x -= this.offsetFromGreenwich;
    }

    public int hashCode() {
        return new Double(this.offsetFromGreenwich).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PrimeMeridian) {
            return this.offsetFromGreenwich == ((PrimeMeridian)object).offsetFromGreenwich;
        }
        return false;
    }

    public String toString() {
        return "PM[" + this.name + ": " + this.offsetFromGreenwich + "]";
    }
}

